<?php
/**
 * Plugin Name: Ultimate Member
 * Plugin URI: http://ultimatemember.com/
 * Description: The easiest way to create powerful online communities and beautiful user profiles with WordPress
 * Version: 2.11.1
 * Author: Ultimate Member
 * Author URI: http://ultimatemember.com/
 * License: GPLv3
 * License URI: http://www.gnu.org/licenses/gpl-3.0.txt
 * Text Domain: ultimate-member
 * Domain Path: /languages
 * Requires at least: 6.2
 * Requires PHP: 7.0
 *
 * @package UM
 */

defined( 'ABSPATH' ) || exit;

require_once ABSPATH . 'wp-admin/includes/plugin.php';
$plugin_data = get_plugin_data( __FILE__, true, false );

// phpcs:disable Generic.NamingConventions.UpperCaseConstantName
define( 'um_url', plugin_dir_url( __FILE__ ) );
define( 'um_path', plugin_dir_path( __FILE__ ) );
define( 'um_plugin', plugin_basename( __FILE__ ) );
define( 'ultimatemember_version', $plugin_data['Version'] );
define( 'ultimatemember_plugin_name', $plugin_data['Name'] );
// phpcs:enable Generic.NamingConventions.UpperCaseConstantName

define( 'UM_URL', plugin_dir_url( __FILE__ ) );
define( 'UM_PATH', plugin_dir_path( __FILE__ ) );
define( 'UM_PLUGIN', plugin_basename( __FILE__ ) );
define( 'UM_VERSION', $plugin_data['Version'] );
define( 'UM_PLUGIN_NAME', $plugin_data['Name'] );
define( 'UM_WP_FUNCTIONS_VERSION', '6.8.0' ); // Updates every major WordPress release.
define( 'UM_LICENSE_REQUEST_DEBUG', false ); // Set true then need to debug the license request.
define( 'UM_UPDATER_DEBUG', false ); // Set true then need to debug the upgrade packages.
// define( 'UM_DEV_MODE', true );

require_once 'includes/class-functions.php';
require_once 'includes/class-init.php';
