<div class="fwdmgz-dummy-wp">
	<?php
		$settings = array("media_buttons" => true, "wpautop" => true, "editor_class" => "fwd_editor_class", "tinymce" => true);
		wp_editor("", "dummy", $settings);
	?>
</div>


<!-- Image dialogs. -->
<div id="add-image-dialog" title="<?php esc_html_e("Add new image","fwdmgz"); ?>">
	<p id="add_image_tips"><?php esc_html_e("The image name and image source path are required.","fwdmgz"); ?></p>
	
	<fieldset>
    	<label for="image_name"><?php esc_html_e("Image name:","fwdmgz"); ?></label>
    	<input type="text" id="image_name" class="text ui-widget-content ui-corner-all">
		<table>
			<tr>
				<td>
					<label for="image_source"><?php esc_html_e("Image source:","fwdmgz"); ?></label>
					<input id="image_source" type="text" class="text ui-widget-content ui-corner-all">
					<button id="upload_image_source_button"><?php esc_html_e("Add image","fwdmgz"); ?></button>
					<img src="<?php echo esc_url($toolTipImgSrc); ?>"
					title="<?php esc_html_e("The image path of the image that the zoomer will display.","fwdmgz"); ?>">
				</td>
				<td>
					<img src="" id="thumb_source">
				</td>
				
			</tr>	
		</table>
	
		<label class="info-window-label"><?php esc_html_e("Info window text:","fwdmgz"); ?></label>
		<?php
			$settings = array("media_buttons" => false, "wpautop" => false, "editor_class" => "fwd_editor_class", "tinymce" => false);
			wp_editor("", "thtext", $settings);

		?>
		<div id="markers"></div>
		<button id="add_marker"><?php esc_html_e("Add marker","fwdmgz"); ?></button>
  	</fieldset>
</div>

<div id="edit-image-dialog" title="<?php esc_html_e("Edit image","fwdmgz"); ?>">
	<p id="edit_image_tips"><?php esc_html_e("The image name and image source path are required.","fwdmgz"); ?></p>
	
	<fieldset>
    	<label for="image_name_edit"><?php esc_html_e("Image name:","fwdmgz"); ?></label>
    	<input type="text" id="image_name_edit" class="text ui-widget-content ui-corner-all">
		<table>
			<tr>
				<td>
					<label for="image_source_edit"><?php esc_html_e("Image source:","fwdmgz"); ?></label>
					<input id="image_source_edit" type="text" class="text ui-widget-content ui-corner-all">
					<button id="upload_image_button_edit"><?php esc_html_e("Add image","fwdmgz"); ?></button>
					<img src="<?php echo esc_url($toolTipImgSrc); ?>"
					title="<?php esc_html_e("The image path of the image that the zoomer will display.","fwdmgz"); ?>">
				</td>
				<td>
					<img src="" id="thumb_source_edit">
				</td>
			</tr>
		</table>
		<label class="info-window-label"><?php esc_html_e("Info window text:","fwdmgz"); ?></label>
		<?php
			$settings = array("media_buttons" => false, "wpautop" => true, "editor_class" => "fwd_editor_class", "tinymce" => false);
			wp_editor("", "thtextedit", $settings);
		?>
		<div id="markers_edit"></div>
		<button id="add_marker_edit"><?php esc_html_e("Add marker","fwdmgz"); ?></button>
  	</fieldset>
</div>

<div id="delete-image-dialog" title="<?php esc_html_e("Delete image","fwdmgz"); ?>">
	<fieldset>
    	<label><?php esc_html_e("Are you sure you want to delete this image?","fwdmgz"); ?></label>
  	</fieldset>
</div>


<!-- Markers dialog. -->
<div id="add_marker_dialog" title="<?php esc_html_e("Add marker","fwdmgz"); ?>">
	<label for="select_markers"><?php esc_html_e("Select markers:","fwdmgz"); ?></label>
	<select id="select_markers" class="ui-widget ui-corner-all"></select>
	 
	<label for="marker_x"><?php esc_html_e("X position:","fwdmgz"); ?></label>
	<input id="marker_x" type="text" class="text ui-widget-content ui-corner-all">
 
	<label for="marker_y"><?php esc_html_e("Y position:","fwdmgz"); ?></label>
	<input id="marker_y" type="text" class="text ui-widget-content ui-corner-all">

	<label for="offset_x"><?php esc_html_e("Offset X:","fwdmgz"); ?></label>
	<input id="offset_x" type="text" class="text ui-widget-content ui-corner-all">
	<label for="markerImageHolder" class="marker-label"><?php esc_html_e("Click on the image at the position where you want the marker to be placed:","fwdmgz"); ?></label>
	<div id="markerImageHolder">
		<img id="markerImage"></img>
	</div>	 
</div>

<div id="delete-marker-dialog" title="<?php esc_html_e("Delete marker","fwdmgz"); ?>">
	<fieldset>
    	<label><?php esc_html_e("Are you sure you want to delete this marker?","fwdmgz"); ?></label>
  	</fieldset>
</div>

<!-- Generate interface -->
<form action="" method="post" class="fwdmgz">
	<div class="form ui-widget ui-widget-content ui-corner-all">
		<h3><?php esc_html_e('All images:', 'fwdmgz'); ?></h3>
	  	
		<div id="main_prodcuts">
			<?php 
				$prodcuts_str = "";
				if (isset($this->_data->main_prodcuts_ar)){
		    		foreach ($this->_data->main_prodcuts_ar as $pid => $image){
						$prodcuts_str .= "<div id='" . esc_html($image['name']) . "' class='main-image-holder image-count'>";
						$prodcuts_str .= "<h3 class='image-header-sort image-header'><span>" . esc_html($image["name"]) . "</span></h3>";
						$prodcuts_str .= "<img src='" . esc_url_raw($image['imageSource']) . "' class='fwdmgz-img' id='image" . esc_html($image["name"]) . "_img'></img>";
						$prodcuts_str .= "<button class='edit_image_btn' id='" . esc_html($image['name']) . "_edit_btn'>" . esc_html__("Edit image", "fwdmgz") . "</button>";
						$prodcuts_str .= "<button class='delete_image_btn' id='" . esc_html($image['name']) . "_del_btn'>" .  esc_html__("Delete image", "fwdmgz") . "</button>";
						$prodcuts_str .= "</div>";
	    			}
					echo $prodcuts_str;
				}
			?>
		</div>
		<em id="mp_em"><?php esc_html_e("No images are available.","fwdmgz"); ?></em>
		<button id="add_main_prodcut_btn"><?php esc_html_e("Add new image","fwdmgz"); ?></button>
		<button id="add_bulk_btn"><?php esc_html_e("Add bulk images","fwdmgz"); ?></button>
  	</div>
  	<input type="hidden" id="product_data" name="product_data" value="">
	<input id="update_btn" type="submit" name="submit" value="<?php esc_html_e("Update main images","fwdmgz"); ?>" />
	<?php wp_nonce_field("fwdzoomer_prodcut_manager_update", "fwdzoomer_product_manager_nonce"); ?>
</form>

<?php if(!(empty($msg))): ?>
<div class='fwd-updated'>
	<p class="fwd-updated-p">
		<?php echo esc_html($msg); ?>
	</p>
</div>
<?php endif; ?>