<?php
/*
Plugin Name: Mega Zoom & Pan Image Viewer
Plugin URI: http://codecanyon.net/user/FWDesign/portfolio
Description: Wordpress plugin with a CMS menu for the installation and configuration of the Mega Zoom & Pan Image Viewer
Author: FWD
Version: 4.1
Text Domain: fwdmgz
Author URI: http://webdesign-flash.ro/
*/

include_once "php/FWDMGZ.php";
include_once "php/FWDZoomerData.php";

function fwdmgz_check_if_admin(){
	$roles = wp_get_current_user()->roles;
	$role = "administrator";
	return in_array($role, $roles);
}

function fwdmgz_zoomer_admin_init(){
	if (fwdmgz_check_if_admin()){
		$role = get_role("administrator");
		$role->add_cap(FWDMGZ::CAPABILITY);
	}
}

function fwdmgz_init_zoomer(){	
	$pv = new FWDMGZ();
	$pv->init();
}

add_action("init", "fwdmgz_init_zoomer");
add_action("admin_init", "fwdmgz_zoomer_admin_init");
add_filter("plugin_action_links_" . plugin_basename(__FILE__), array("FWDMGZ", "fwdmgz_set_action_links"));
?>