<?php
namespace Elementor\Includes\Elements;

use Elementor\Plugin;
use Elementor\Utils;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
#[\AllowDynamicProperties]
class Element_TheGem_Container extends Container {

	public function __construct( array $data = [], array $args = null ) {
		parent::__construct( $data, $args );

		$this->active_kit = Plugin::$instance->kits_manager->get_active_kit();
	}

	protected function content_template() {
		?>
		<# if ( 'boxed' === settings.content_width ) { #>
			<div class="e-con-inner">
		<#
		}
		if ( settings.thegem_ken_burns_active ) { #>
			<div class="thegem-ken-burns-bg"><div class="thegem-ken-burns-bg-slide"></div></div>
		<#
		}
		if ( settings.background_video_link ) {
			let videoAttributes = 'autoplay muted playsinline';

			if ( ! settings.background_play_once ) {
				videoAttributes += ' loop';
			}

			view.addRenderAttribute( 'background-video-container', 'class', 'elementor-background-video-container' );

			if ( ! settings.background_play_on_mobile ) {
				view.addRenderAttribute( 'background-video-container', 'class', 'elementor-hidden-mobile' );
			}
			#>
			<div {{{ view.getRenderAttributeString( 'background-video-container' ) }}}>
				<div class="elementor-background-video-embed"></div>
				<video class="elementor-background-video-hosted" {{ videoAttributes }}></video>
			</div>
		<# } #>
		<div class="elementor-shape elementor-shape-top"></div>
		<div class="elementor-shape elementor-shape-bottom"></div>
		<# if ( 'boxed' === settings.content_width ) { #>
			</div>
		<# } #>
		<?php
	}

	/**
	 * Before rendering the container content. (Print the opening tag, etc.)
	 *
	 * @return void
	 */
	public function before_render() {
		$settings = $this->get_settings_for_display();
		$link = $settings['link'];

		if ( ! empty( $link['url'] ) ) {
			$this->add_link_attributes( '_wrapper', $link );
		}

		if ( ! empty( $settings['thegem_ken_burns_active'] ) ) {
			$this->add_render_attribute( '_wrapper', 'class', 'thegem-ken-burns-block' );
		}

		?><<?php $this->print_html_tag(); ?> <?php $this->print_render_attribute_string( '_wrapper' ); ?>>
		<?php
		if ( $this->is_boxed_container( $settings ) ) { ?>
			<div class="e-con-inner">
		<?php }

		if (!empty($settings['thegem_ken_burns_active'])) {
			wp_enqueue_style('thegem-container-ken-burns');
			wp_enqueue_script('thegem-container-ken-burns');

			$transition = $settings['thegem_ken_burns_transition'] ?? 500;
			$slides_data = [];
			$first_slide_attrs = [];

			if (!empty($settings['thegem_ken_burns_slides'])) {
				foreach ($settings['thegem_ken_burns_slides'] as $i => $slide) {
					if (!empty($slide['image']['url'])) {
						$slide_data = [
							'url' => $slide['image']['url'],
							'duration' => !empty($slide['animation_duration']) ? $slide['animation_duration'] : (count($settings['thegem_ken_burns_slides']) > 1 ? 5000 : 15000),
							'direction' => $slide['animation_direction'] ?? 'zoom-in'
						];

						$slides_data[] = $slide_data;

						if ($i === 0) {
							$first_slide_attrs = [
								'style' => 'background-image: url(' . esc_url($slide['image']['url']) . ')',
								'data-direction' => $slide_data['direction'],
								'data-duration' => $slide_data['duration']
							];
						}
					}
				}
			}

			$this->add_render_attribute('ken_burns_wrapper', [
				'class' => 'thegem-ken-burns-bg',
				'data-transition' => $transition,
				'data-slides' => htmlspecialchars(json_encode($slides_data), ENT_QUOTES, 'UTF-8'),
			]);

			$this->add_render_attribute('first_slide', [
				'class' => 'thegem-ken-burns-slide',
			] + $first_slide_attrs);

			echo '<div ' . $this->get_render_attribute_string('ken_burns_wrapper') . '>';
			echo '<div ' . $this->get_render_attribute_string('first_slide') . '></div>';
			echo '</div>';

			if (!empty($first_slide_attrs)) {
				echo '<style>#elementor-element-' . $this->get_id() . ' .thegem-ken-burns-bg {';
				echo '--duration: ' . ($first_slide_attrs['data-duration'] ?? 5000) . 'ms;';
				echo '--transition: ' . $transition . 'ms;';
				echo '}</style>';
			}
		}

		$this->render_video_background();

		if ( ! empty( $settings['shape_divider_top'] ) ) {
			$this->render_shape_divider( 'top' );
		}

		if ( ! empty( $settings['shape_divider_bottom'] ) ) {
			$this->render_shape_divider( 'bottom' );
		}
	}

}
