<?php

/**
 * Main class.
 *
 * @package fwdmgz
 * @since fwdmgz 1.0
 */

class FWDZoomerData {
	
	const DEFAULT_SKINS_NR = 8;
	public $settings_ar;
    public $main_prodcuts_ar;
    public $main_markers_ar;
	public $info_window_str = "";
	
    // constructor
    public function init(){
		$cur_data = get_option("fwdzoomer_data");
		
		// Uncomment this to reset data! 
		//$this->reset_presets();
		//$this->reset_playlist();
		//$this->reset_markers();
		//$this->reset_info_window();
	       
	    if (!$cur_data){
	    	$this->init_settings();
	    	$this->set_data();
	    }
		
		$this->set_updates();
		$this->get_data();
    }
	
	private function reset_presets(){
		$this->get_data();
		$this->init_settings();
	    $this->set_data();
	}
	
	private function reset_playlist(){
		$this->get_data();
		$this->main_prodcuts_ar = array();
		$this->set_data();
	}
	
	private function reset_markers(){
		$this->get_data();
		$this->main_markers_ar = array();
		$this->set_data();
	}
	
	private function reset_info_window(){
		$this->get_data();
		$this->info_window_str = "";
		$this->set_data();
	}

	// Set updates.

	private function set_updates(){
		$this->get_data();
		
   		foreach ($this->settings_ar as &$preset){

			// Update new or existing fields.
   			if(!array_key_exists("hideMarkersByDefault", $preset)){
				$preset["hideMarkersByDefault"] = "no";
			}

			if(!array_key_exists("registrationPoint", $preset)){
				$preset["registrationPoint"] = "center";
			}

		}

		$this->set_data();
	}
    
    // Init settings.
    private function init_settings(){
    	$this->settings_ar = array(
			array(	
				// Main settings.
				"id" 										=> 0,
				"name" 										=> "skin1",
				"display_type" 								=> "responsive",
				"skin_path" 								=> "skin1",
				"preloaderText" 							=> "Loading image ...",
				"initializeOnlyWhenVisible" 				=> "no",
				"use_entire_screen" 						=> "yes",
				"useVectorIcons" 							=> "no",
				"add_keyboard_support" 						=> "yes",
				"add_double_click_support" 					=> "yes",
				"doubleClickZoomFactor" 					=> 1,
				"disable_mouse_wheel" 						=> "no",
				"auto_scale" 								=> "yes",
				"registrationPoint" 						=> "center",
				"start_at_image" 							=> 0,
				"viewer_width" 								=> 1000,
				"viewer_height" 							=> 790,
				"imageOffsetX" 								=> 0,
				"imageOffsetY" 								=> 0,
				"image_width" 								=> 0,
				"image_height" 								=> 0,
				"zoom_factor" 								=> 1.0,
				"start_zoom_factor" 						=> "default",
				"pan_speed" 								=> 8,
				"zoomSpeed" 								=> 0.1,
				"slide_show_delay" 							=> 300,
				"marker_width" 								=> 24,
				"marker_height" 							=> 33,
				"background_color" 							=> "rgba(255,255,255,1)",
				"backgroundColorOnZoom" 					=> "rgba(255,255,255,0)",
				"fullscreenBackgroundColor" 				=> "#FFFFFF",

				// Lightbox.
				"light_box_width" 							=> 1000,
				"light_box_height" 							=> 790,
				"light_box_background_opacity" 				=> .8,
				"light_box_background_color" 				=> "#000000",

				// Preloader.
				"preloaderText" 							=> "Loading image: ",
				"preloaderPosition" 						=> "center",
				"preloaderOffsetX" 							=> 40,
				"preloaderOffsetY" 							=> 40,
				"showPreloaderProgressBar" 					=> "yes",
				"preloaderWidth" 							=> "70%",
				"preloaderProgressBarBackgroundColor" 		=> "#8b859b",
				"preloaderProgressBarFillColor" 			=> "#7EC1AB",
				"preloaderWindowBackgroundOpacity" 			=> .7,
				"preloaderBackgroundSize" 					=> "large",
				"preloaderBackgroundColor" 					=> "#FFFFFF",
				"preloaderFontColor" 						=> "#000000",
			
				// Controller settings.
				"buttons" 									=> "moveLeft, moveRight, moveDown, moveUp, scrollbar, hideOrShowMarkers, hideOrShowController, info, fullscreen",
				"buttons_tool_tips" 						=> "Move left, Move right, Move down, Move up, Zoom level: , Hide markers/Show markers, Hide controller/Show controller, Info, Full screen/Normal screen",
				"controllerVerticalPosition" 				=> "bottom",
				"controllerHorizontalPosition" 				=> "center",
				"showControllerBackground" 					=> "yes",
				"inverse_pan_direction" 					=> "yes",
				"startSpaceBetweenButtons" 					=> 28,
				"space_between_buttons" 					=> 10,
				"start_space_for_scroll_bar_buttons" 		=> 20,
				"start_space_for_scroll_bar" 				=> 6,
				"hide_controller_delay"	 					=> 3,
				"controller_max_width" 						=> 934,
				"controller_background_opacity" 			=> 1,
				"controllerOffsetWidth" 					=> 20,
				"controller_offset_y" 						=> 10,
				"scrollBarHandlerOffsetX" 					=> 4,
				"scroll_bar_offset_x" 						=> 0,
				"scroll_bar_handler_tool_tip_offset_y" 		=> 4,
				"zoom_in_and_out_tool_tip_offset_y" 		=> -10,
				"buttons_tool_tip_offset_y" 				=> -10,
				"hide_controller_offset_y" 					=> 2,
				"buttonToolTipBackgroundColor" 				=> "#FFFFFF",
				"button_tool_tip_font_color" 				=> "#585858",
				
				// Navigator.
				"show_navigator" 							=> "yes",
				"show_navigator_on_mobile" 					=> "no",
				"navigator_position" 						=> "topright",
				"navigatorWidth"	 						=> 120,
				"navigator_offset_x" 						=> 6,
				"navigator_offset_y" 						=> 6,
				"navigatorBackgroundColor" 					=> "#FFFFFF",
				"navigator_handler_color" 					=> "#7EC1AB",
				"navigator_border_color" 					=> "#E5E4E8",
				
				// Info window.
				"infoWindowWidth" 							=> 920,
				"info_window_background_opacity" 			=> .6,
				"info_window_background_color" 				=> "#FFFFFF",
				"info_window_scroll_bar_color" 				=> "#585858",
				
				// Markers.
				"hideMarkersByDefault"						=> "no",
				"show_markers_info" 						=> "no",
				"marker_tool_tip_offset_y" 					=> 2,

				// Constext menu.
				"showScriptDeveloper" 						=> "yes",
				"context_menu_labels" 						=> "Move left, Move right, Move down, Move up, Zoom in/Zoom out, Hide markers/Show markers, Hide controller/Show controller, Info, Full screen/Normal screenn",
				"contextMenuBorderColor" 					=> "rgba(0,0,0,0)",
				"contextMenuSpacerColor" 					=> "#E5E4E8",
				"contextMenuItemTextNormalColor" 			=> "#3a334b",
				"contextMenuItemTextSelectedColor"  		=> "#FFFFFF",
				"contextMenuItemBackgroundNormalColor"  	=> "#FFFFFF",
				"contextMenuItemBackgroundSelectedColor" 	=> "#7EC1AB",
				"contextMenuItemDisabledColor"  			=> "#cccccc"
			),
			array(

				// Main settings.
				"id" 										=> 1,
				"name" 										=> "skin2",
				"display_type" 								=> "responsive",
				"skin_path" 								=> "skin2",
				"initializeOnlyWhenVisible" 				=> "no",
				"use_entire_screen" 						=> "yes",
				"useVectorIcons" 							=> "no",
				"add_keyboard_support" 						=> "yes",
				"add_double_click_support" 					=> "yes",
				"doubleClickZoomFactor" 					=> 1,
				"disable_mouse_wheel" 						=> "no",
				"auto_scale" 								=> "yes",
				"registrationPoint" 						=> "center",
				"start_at_image" 							=> 0,
				"viewer_width" 								=> 1000,
				"viewer_height" 							=> 790,
				"imageOffsetX" 								=> 0,
				"imageOffsetY" 								=> 0,
				"image_width" 								=> 0,
				"image_height" 								=> 0,
				"zoom_factor" 								=> 1.0,
				"start_zoom_factor" 						=> "default",
				"pan_speed" 								=> 8,
				"zoomSpeed" 								=> 0.1,
				"slide_show_delay" 							=> 300,
				"marker_width" 								=> 24,
				"marker_height" 							=> 33,
				"background_color" 							=> "rgba(255,255,255,1)",
				"backgroundColorOnZoom" 					=> "rgba(255,255,255,0)",
				"fullscreenBackgroundColor" 				=> "#FFFFFF",

				// Lightbox.
				"light_box_width" 							=> 1000,
				"light_box_height" 							=> 790,
				"light_box_background_opacity" 				=> .8,
				"light_box_background_color" 				=> "#000000",

				// Preloader.
				"preloaderText" 							=> "Loading image: ",
				"preloaderPosition" 						=> "center",
				"preloaderOffsetX" 							=> 40,
				"preloaderOffsetY" 							=> 40,
				"showPreloaderProgressBar" 					=> "yes",
				"preloaderWidth" 							=> "70%",
				"preloaderProgressBarBackgroundColor" 		=> "#8b859b",
				"preloaderProgressBarFillColor" 			=> "#7EC1AB",
				"preloaderWindowBackgroundOpacity" 			=> .7,
				"preloaderBackgroundSize" 					=> "large",
				"preloaderBackgroundColor" 					=> "#FFFFFF",
				"preloaderFontColor" 						=> "#000000",
			
				// Controller settings.
				"buttons" 									=> "moveLeft, moveRight, moveDown, moveUp, scrollbar, hideOrShowMarkers, hideOrShowController, info, fullscreen",
				"buttons_tool_tips" 						=> "Move left, Move right, Move down, Move up, Zoom level: , Hide markers/Show markers, Hide controller/Show controller, Info, Full screen/Normal screen",
				"controllerVerticalPosition" 				=> "bottom",
				"controllerHorizontalPosition" 				=> "center",
				"showControllerBackground" 					=> "yes",
				"inverse_pan_direction" 					=> "yes",
				"startSpaceBetweenButtons" 					=> 28,
				"start_space_between_buttons" 				=> 10,
				"space_between_buttons" 					=> 10,
				"start_space_for_scroll_bar_buttons" 		=> 10,
				"start_space_for_scroll_bar" 				=> 30,
				"hide_controller_delay" 					=> 3,
				"controller_max_width" 						=> 934,
				"controller_background_opacity" 			=> 1,
				"controller_offset_y" 						=> 10,
				"controllerOffsetWidth" 					=> 20,
				"scrollBarHandlerOffsetX" 					=> 4,
				"scroll_bar_offset_x" 						=> 0,
				"scroll_bar_handler_tool_tip_offset_y" 		=> 4,
				"zoom_in_and_out_tool_tip_offset_y" 		=> 5,
				"buttons_tool_tip_offset_y" 				=> 5,
				"hide_controller_offset_y" 					=> 4,
				"buttonToolTipBackgroundColor" 				=> "#FFFFFF",
				"button_tool_tip_font_color" 				=> "#a2a3a3",
				
				// Navigator.
				"show_navigator" 							=> "yes",
				"show_navigator_on_mobile" 					=> "no",
				"navigator_position" 						=> "topright",
				"navigatorWidth" 							=> 120,
				"navigator_offset_x" 						=> 10,
				"navigator_offset_y" 						=> 10,
				"navigatorBackgroundColor" 					=> "#FFFFFF",
				"navigator_handler_color" 					=> "#7EC1AB",
				"navigator_border_color" 					=>"#E5E4E8",
				
				// Info window.
				"infoWindowWidth" 							=> 920,
				"info_window_background_opacity" 			=> .6,
				"info_window_background_color" 				=> "#FFFFFF",
				"info_window_scroll_bar_color"	 			=> "#585858",
				
				// Markers.
				"hideMarkersByDefault"						=> "no",
				"show_markers_info" 						=> "no",
				"marker_tool_tip_offset_y" 					=> 2,

				// Constext menu.
				"showScriptDeveloper" 						=>"yes",
				"context_menu_labels" 						=> "Move left, Move right, Move down, Move up, Zoom in/Zoom out, Hide markers/Show markers, Hide controller/Show controller, Info, Full screen/Normal screenn",
				"contextMenuBorderColor" 					=> "rgba(0,0,0,0)",
				"contextMenuSpacerColor" 					=> "#E5E4E8",
				"contextMenuItemTextNormalColor" 			=> "#3a334b",
				"contextMenuItemTextSelectedColor"  		=> "#FFFFFF",
				"contextMenuItemBackgroundNormalColor"  	=> "#FFFFFF",
				"contextMenuItemBackgroundSelectedColor"  	=> "#7EC1AB",
				"contextMenuItemDisabledColor"  			=> "#cccccc"
			)
		);
    }


    // Get data.
    public function get_data(){
	    $cur_data = get_option("fwdzoomer_data");
	       
	    $this->settings_ar = $cur_data->settings_ar;
	    $this->main_prodcuts_ar = $cur_data->main_prodcuts_ar;
		$this->main_markers_ar = $cur_data->main_markers_ar;
		$this->info_window_str = $cur_data->info_window_str;	
    }
    
    public function set_data(){
    	update_option("fwdzoomer_data", $this);
    }
}

?>