<?php
/**
 * Main class.
 *
 * @package fwdmgz
 * @since fwdmgz 1.0
 */

class FWDMGZ{
	
	const MIN_WP_VER =  "3.5.0";
	const CAPABILITY = "edit_fwdzoomer";
	const VERSION = '4.1';
	private $_data;
	private $_dir_url;
	private $_is_Ligtbox_initialized = FALSE;
    private static $_zoomer_id = 0;
	private static $_image_name = 0;
    private static $_pl_id = 0;

    
    // Initialize
    public function init(){
	
		$this->_dir_url = plugin_dir_url(dirname(__FILE__));
		
    	// Set hooks.
    	add_action("admin_menu", array($this, "add_plugin_menu"));
		add_action("wp_enqueue_scripts", array($this, "fwdmgz_add_header_files"));
		add_action('admin_enqueue_scripts', array($this, "fwdmgz_enqueue_admin_files"));
		add_shortcode("fwdzoomer", array($this, "setZoomer"));
	
		// Set data.
		$this->_data = new FWDZoomerData();
		$this->_data->init();

		// Make plugin available for translation.
		$tes = load_plugin_textdomain('fwdmgz', false, basename(realpath(__DIR__ . '/..')) . '/languages/');
    }
	
    // Add menu.
    public function add_plugin_menu(){
		
    	// Add menus.
        add_menu_page("Mega Zoom & Pan Image zoomer", "Mega Zoom & Pan Image zoomer", FWDMGZ::CAPABILITY, "fwdmgz-general-settings", array($this, "set_general_settings"), esc_url_raw($this->_dir_url) . "content/icons/menu-icon.png");
		add_submenu_page("fwdmgz-general-settings", esc_html__("General settings", "fwdmgz"), esc_html__("General settings", "fwdmgz"), FWDMGZ::CAPABILITY, "fwdmgz-general-settings");
		add_submenu_page("fwdmgz-general-settings", esc_html__("Images manager", "fwdmgz"), esc_html__("Images manager", "fwdmgz"), FWDMGZ::CAPABILITY, "fwdmgz-images-manager", array($this, "fwdmgz_set_images_manager"));
		add_submenu_page("fwdmgz-general-settings", esc_html__("Markers manager", "fwdmgz"),  esc_html__("Markers manager", "fwdmgz"), FWDMGZ::CAPABILITY, "fwdmgz-markers-manager", array($this, "fwdmgz_set_markers_manager"));
		add_submenu_page("fwdmgz-general-settings", esc_html__("CSS Editor", "fwdmgz"), esc_html__("CSS Editor", "fwdmgz"), FWDMGZ::CAPABILITY, "fwdmgz-css-editor", array($this, "fwdmgz_set_css_editor"));

		// Add meta boxes.
        $post_type_screens = array("post", "page");
       	$args = array(
	       'public'   => true,
	       '_builtin' => false,
	    );
       	$custom_post_types = get_post_types($args);

       	foreach ($custom_post_types as $screen){
       		$post_type_screens[] = $screen;
       	}

    	foreach($post_type_screens as $screen){
       		add_meta_box("fwdmgz-shortcode-generator", "Mega Zoom & Pan Image Zcoomer Shortcode Generator",  array($this, "set_custom_meta_box"), $screen, "side", "default");
    	}
    }
	

	// Add header files.
    public function fwdmgz_add_header_files(){
     	global $post, $wpdb;
     	if(empty($post)) return;

		$shortcode_found = false;
       	if(has_shortcode($post->post_content, 'fwdzoomer')){
          	$shortcode_found = true;
       	}else if(isset($post->ID)){ 
          	$result = $wpdb->get_var($wpdb->prepare(
            "SELECT count(*) FROM $wpdb->postmeta " .
            "WHERE post_id = %d and meta_value LIKE '%%fwdzoomer%%'", $post->ID));
          	$shortcode_found = !empty($result);
       	}
       	
       	// Uncomment this to add the front required js/css files only if the shortcode is found in the page/post.
		//if (!empty($shortcode_found)){
			wp_enqueue_script("fwdmgz", esc_url_raw($this->_dir_url) . "js/FWDM.js", array(), FWDMGZ::VERSION, true);
			wp_enqueue_style("fwdmgz", esc_url_raw($this->_dir_url) . "css/global.css", array(), FWDMGZ::VERSION);
		//}		
	}


	// Add backend files.
	public function fwdmgz_enqueue_admin_files($hook){

		// General settings.
		if($hook == "toplevel_page_fwdmgz-general-settings"){
			wp_enqueue_style("fwdmgz-fwd-ui-css", $this->_dir_url . "css/fwd_ui.css", array(), '1.10.4');
    		wp_enqueue_style("fwdmgz_general_settings", esc_url_raw($this->_dir_url) . "css/general_settings.css", array(), FWDMGZ::VERSION);
    		wp_enqueue_style("fwdmgz_fwd_ui", esc_url_raw($this->_dir_url) . "css/fwd_ui.css", array(), '1.10.4');
    		wp_enqueue_style("fwdmgz_spectrum_css", esc_url_raw($this->_dir_url) . "css/spectrum.css");
    		wp_enqueue_script("fwdmgz_fwdtooltip", esc_url_raw($this->_dir_url) . "js/fwdtooltip.js", array(), '1.0');
	    	wp_enqueue_script("fwdmgz_spectrum_script", esc_url_raw($this->_dir_url) . "js/spectrum.js");
	     	wp_enqueue_script("fwdmgz_general_settings_script", esc_url_raw($this->_dir_url) . "js/general_settings.js", array(), FWDMGZ::VERSION, true);
    		wp_enqueue_script("jquery-ui-tabs");
			wp_enqueue_script("jquery-ui-sortable");
			wp_enqueue_script("jquery-ui-accordion");
			wp_enqueue_media();
		
		// Image manager.
		}else if($hook == "mega-zoom-pan-image-zoomer_page_fwdmgz-images-manager"){
			wp_enqueue_style("fwdmgz_fwd_ui", esc_url_raw($this->_dir_url) . "css/fwd_ui.css", array(), '1.10.4');
    		wp_enqueue_script("fwdmgz_fwdtooltip", esc_url_raw($this->_dir_url) . "js/fwdtooltip.js", array(), '1.0');
    		wp_enqueue_style("fwdmgz_product_manager", esc_url_raw($this->_dir_url) . "css/image_manager.css", array(), FWDMGZ::VERSION);
			wp_enqueue_script("fwdmgz_product_manager_script", esc_url_raw($this->_dir_url) . "js/product_manager.js", array(), FWDMGZ::VERSION, true);
			wp_enqueue_script("fwdmgz_viwer", esc_url_raw($this->_dir_url) . "js/FWDM.js", array(), FWDMGZ::VERSION, true);
			wp_enqueue_script("jquery-ui-tabs");
			wp_enqueue_script("jquery-ui-sortable");
			wp_enqueue_script("jquery-ui-accordion");
			wp_enqueue_script("jquery-ui-dialog");
			wp_enqueue_media();

		// Markers.
		}else if($hook == "mega-zoom-pan-image-zoomer_page_fwdmgz-markers-manager"){
    		wp_enqueue_style("fwdmgz-fwd-ui-css", $this->_dir_url . "css/fwd_ui.css", array(), '1.10.4');
    		wp_enqueue_script("fwdmgz_fwdtooltip", esc_url_raw($this->_dir_url) . "js/fwdtooltip.js", array(), '1.0');
    		wp_enqueue_style("fwdmgz_markers", esc_url_raw($this->_dir_url) . "css/markers.css", array(), FWDMGZ::VERSION);
    		wp_enqueue_script("fwdmgz_markers_script", esc_url_raw($this->_dir_url) . "js/markers_manager.js", array(), FWDMGZ::VERSION, true);
    		wp_enqueue_script("jquery-ui-sortable");
			wp_enqueue_script("jquery-ui-accordion");
			wp_enqueue_script("jquery-ui-dialog");
			wp_enqueue_media();

		// CSS editor.
		}else if($hook == "mega-zoom-pan-image-zoomer_page_fwdmgz-css-editor"){
			wp_enqueue_style("fwdmgz_fwd_ui_css", esc_url_raw($this->_dir_url) . "css/fwd_ui.css", array(), '1.10.4');
    		wp_enqueue_style("fwdmgz_css_editor", esc_url_raw($this->_dir_url) . "css/css_editor.css", array(), FWDMGZ::VERSION);
			wp_enqueue_script("fwdmgz_css_editor", esc_url_raw($this->_dir_url) . "js/css_editor.js", array(), FWDMGZ::VERSION);

		// Shortcode.
    	}else if($hook == 'post.php' || $hook == 'post-new.php'){
    		wp_enqueue_style("fwdmgz_fwd_ui", esc_url_raw($this->_dir_url) . "css/fwd_ui.css");
    		wp_enqueue_style("fwdmgz_css", esc_url_raw($this->_dir_url) . "css/shortcode.css", array(), FWDMGZ::VERSION);
			wp_enqueue_script("fwdmgz_shortcode", esc_url_raw($this->_dir_url) . "js/shortcode.js", array(), FWDMGZ::VERSION, true);
    	}
	}

    public function set_general_settings(){
    	if (!$this->fwdmgz_check_wp_ver()){
    		return;
    	}
    	
    	$iconsPath = esc_url_raw($this->_dir_url) . "content/icons/";
		$toolTipImgSrc = esc_url_raw($this->_dir_url) . "content/icons/help-icon.png"; 
		$iconsPath = esc_url_raw($this->_dir_url) . "content/icons/";
    	
    	// Update data.
    	$set_id = 0;
		$set_order_id = 0;
		$tab_init_id = 0;
    	
	    if (!empty($_POST) && check_admin_referer("FWDMGZ_general_settings_update", "FWDMGZ_general_settings_nonce")){
			$data_obj = json_decode(str_replace("\\", "", $_POST["settings_data"]), true);
			
			$action = $data_obj["action"];
			$settingsAr = $data_obj["settings_ar"];


			// Validate input.
			foreach ($settingsAr as $key => $value) {

				if(!empty($settingsAr[$key]["name"])){
					$settingsAr[$key]["name"] = sanitize_text_field($this->fwdmgz_clean($settingsAr[$key]["name"]));
				}

				if(!empty($settingsAr[$key]["start_zoom_factor"])){
					$settingsAr[$key]["start_zoom_factor"] = sanitize_text_field($settingsAr[$key]["start_zoom_factor"]);
				}

				if(!empty($settingsAr[$key]["preloaderWidth"])){
					$settingsAr[$key]["preloaderWidth"] = sanitize_text_field($settingsAr[$key]["preloaderWidth"]);
				}

				if(!empty($settingsAr[$key]["buttons"])){
					$settingsAr[$key]["buttons"] = sanitize_text_field($settingsAr[$key]["buttons"]);
				}

				if(!empty($settingsAr[$key]["buttons_tool_tips"])){
					$settingsAr[$key]["buttons_tool_tips"] = sanitize_text_field($settingsAr[$key]["buttons_tool_tips"]);
				}

				if(!empty($settingsAr[$key]["context_menu_labels"])){
					$settingsAr[$key]["context_menu_labels"] = sanitize_text_field($settingsAr[$key]["context_menu_labels"]);
				}
				
			}
			
			$this->_data->settings_ar = $settingsAr;
			$this->_data->set_data();
			
			switch ($action){
			    case "add":
			        $set_id = $data_obj["set_id"];
					$set_order_id = $data_obj["set_order_id"];
					$tab_init_id = $data_obj["tab_init_id"];
					$msg = esc_html__("Your new preset has been added!", 'fwdmgz');
			        break;
			    case "save":
			        $set_id = $data_obj["set_id"];
					$set_order_id = $data_obj["set_order_id"];
					$tab_init_id = $data_obj["tab_init_id"];
					$msg = esc_html__("Your preset settings have been updated!", 'fwdmgz');
			        break;
			    case "del":
			       	$msg = esc_html__("Your preset has been deleted!", 'fwdmgz');
			        break;
			}
		}

		// Add and escape required js vars.
        $vars = 'var fwdmgzSettingsAr = ' . '"' . esc_html(htmlspecialchars(json_encode($this->_data->settings_ar))) . '";';
        $vars .= 'var fwdmgzSetId = ' .  esc_html($set_id) .';';
        $vars .= 'var fwdmgzCurOrderId = ' .  esc_html($set_order_id) .';';
        $vars .= 'var fwdmgzTabInitId = ' . esc_html($tab_init_id) .';';
        $vars .= 'var fwdmgzThe__ = ' . '"' . esc_html__('The', 'fwdmgz') . '";';
        $vars .= 'var fwdmgzMustBeNumber__ = ' . '"' . esc_html__('field value must be a number', 'fwdmgz') . '";';
        $vars .= 'var fwdmgzMustBeWholeNumber__ = ' . '"' . esc_html__('field value must be a whole number', 'fwdmgz') . '";';
        $vars .= 'var fwdmgzLengthOff__ = ' . '"' . esc_html__('Length of', 'fwdmgz') . '";';
     	$vars .= 'var fwdmgzMustBeBetween__ = ' . '"' . esc_html__('must be between', 'fwdmgz') . '";';
     	$vars .= 'var fwdmgzUniquePreset__ = ' . '"' . esc_html__('Please make sure that the preset name is unique.', 'fwdmgz') . '";'; 
     	$vars .= 'var fwdmgzAnd__ = ' . '"' . esc_html__('and', 'fwdmgz') . '";';
     	wp_add_inline_script('fwdmgz_general_settings_script', $vars);

	    include_once "general_settings.php";
    }

	
	// Set markers.
	public function fwdmgz_set_markers_manager(){

    	if (!$this->fwdmgz_check_wp_ver()){
    		return;
    	}

    	$allowed_tags = wp_kses_allowed_html('post');
    	$allowed_tags['iframe'] = array(
			'src'             => array(),
			'height'          => array(),
			'width'           => array(),
			'frameborder'     => array(),
			'allowfullscreen' => array(),
		);
    	
    	$msg = "";
    	$iconsPath = esc_url_raw($this->_dir_url) . "content/icons/";
		$tootlTipImgSrc = esc_url_raw($this->_dir_url) . "content/icons/help-icon.png"; 

	    if (!empty($_POST) && check_admin_referer("fwdmgz_marker_manager_update", "fwdmgz_marker_manager_nonce")){
			$mainMarkerssAr = json_decode(str_replace("\\", "", $_POST["marker_data"]), true);
			
			// Validate input.
			foreach ($mainMarkerssAr as $key => $value) {
				if(!empty($mainMarkerssAr[$key]["name"])){
					$mainMarkerssAr[$key]["name"] = sanitize_text_field($this->fwdmgz_clean($mainMarkerssAr[$key]["name"]));
				}

				if(!empty($mainMarkerssAr[$key]["url"])){
					$mainMarkerssAr[$key]["url"] = esc_url_raw($mainMarkerssAr[$key]["url"]);
				}
			}

			$this->_data->main_markers_ar = $mainMarkerssAr;
			$this->_data->set_data();
			$msg = esc_html__("Your markers have been updated!","fwdmgz");
		}
		
		// Add and escape required js vars.
        $vars = 'var fwdmgzMainPlaylistsAr = ' . '"' . esc_html(htmlspecialchars(json_encode($this->_data->main_markers_ar))) . '";';
        $vars .= 'var fwdmgzEditMarker_ = ' . '"' . esc_html__('Edit marker', 'fwdmgz') . '";';
        $vars .= 'var fwdmgzDeleteMarker_ = ' . '"' . esc_html__('Delete marker', 'fwdmgz') . '";';
        $vars .= 'var fwdmgzAddMarker__ = ' . '"' . esc_html__('Add marker', 'fwdmgz') . '";';
        $vars .= 'var fwdmgzUpdateMarker__ = ' . '"' . esc_html__('Update marker', 'fwdmgz') . '";';
        $vars .= 'var fwdmgzYes__ = ' . '"' . esc_html__('Yes', 'fwdmgz') . '";';
        $vars .= 'var fwdmgzNo__ = ' . '"' . esc_html__('No', 'fwdmgz') . '";';
        $vars .= 'var fwdmgzCancel__ = ' . '"' . esc_html__('Cancel', 'fwdmgz') . '";';
        $vars .= 'var fwdmgzIconsPath = ' . '"' . esc_url_raw($this->_dir_url) . 'content/icons/";';

        wp_add_inline_script('fwdmgz_markers_script', $vars);
    	include_once "marker_manager.php";
	}

    
    // Image manager.
 	public function fwdmgz_set_images_manager(){

    	if (!$this->fwdmgz_check_wp_ver()){
    		return;
    	}

    	$allowed_tags = wp_kses_allowed_html('post');
    	$allowed_tags['iframe'] = array(
			'src'             => array(),
			'height'          => array(),
			'width'           => array(),
			'frameborder'     => array(),
			'allowfullscreen' => array(),
		);
    	
    	$msg = "";
		$toolTipImgSrc = esc_url_raw($this->_dir_url) . "content/icons/help-icon.png"; 

	    if (!empty($_POST) && check_admin_referer("fwdzoomer_prodcut_manager_update", "fwdzoomer_product_manager_nonce")){
			$mainPlaylistsAr = json_decode(str_replace("\\", "", $_POST["product_data"]), true);
		
			foreach ($mainPlaylistsAr as $key => $value) {
				if(!empty($mainPlaylistsAr[$key]["name"])){
					$mainPlaylistsAr[$key]["name"] = sanitize_text_field($this->fwdmgz_clean($mainPlaylistsAr[$key]['name']));
				}

				if(!empty($mainPlaylistsAr[$key]["infoWindowText"])){
					$mainPlaylistsAr[$key]['infoWindowText'] = wp_kses($mainPlaylistsAr[$key]['infoWindowText'], $allowed_tags);
				}
			}

			$this->_data->main_prodcuts_ar = $mainPlaylistsAr;
			$this->_data->set_data();
			$msg = esc_html__("Your images have been updated!","fwdmgz");
		}

		// Add and escape required js vars.
        $vars = 'var fwdmgzProductsAr = ' . '"' . esc_html(htmlspecialchars(json_encode($this->_data->main_prodcuts_ar))) . '";';
		$vars .= 'var fwdmgzpvMarkersAr = ' . '"' . esc_html(htmlspecialchars(json_encode($this->_data->main_markers_ar))) . '";';
		$vars .= 'var iconsPath = ' . '"' . esc_url_raw($this->_dir_url) . "content/icons/" . '";';
		$vars .= 'var fwdmgzYes_ = ' . '"' . esc_html__('Yes', 'fwdmgz') . '";';
		$vars .= 'var fwdmgzNo_ = ' . '"' . esc_html__('No', 'fwdmgz') . '";';
		$vars .= 'var fwdmgzCancel_ = ' . '"' . esc_html__('Cancel', 'fwdmgz') . '";';
		$vars .= 'var fwdmgzBulk_ = ' . '"' . esc_html__('Add bulk images', 'fwdmgz') . '";';
		$vars .= 'var fwdmgzAddImage_ = ' . '"' . esc_html__('Add new image', 'fwdmgz') . '";';
		$vars .= 'var fwdmgzEditImage_ = ' . '"' . esc_html__('Edit image', 'fwdmgz') . '";';
		$vars .= 'var fwdmgzUpdateImage_ = ' . '"' . esc_html__('Update image', 'fwdmgz') . '";';
		$vars .= 'var fwdmgzDeleteImage_ = ' . '"' . esc_html__('Delete image', 'fwdmgz') . '";';
		$vars .= 'var fwdmgzChooseImage_ = ' . '"' . esc_html__('Choose image', 'fwdmgz') . '";';
		$vars .= 'var fwdmgzEditMarker_ = ' . '"' . esc_html__('Edit marker', 'fwdmgz') . '";';
        $vars .= 'var fwdmgzDeleteMarker_ = ' . '"' . esc_html__('Delete marker', 'fwdmgz') . '";';
        $vars .= 'var fwdmgzAddMarker__ = ' . '"' . esc_html__('Add marker', 'fwdmgz') . '";';
        $vars .= 'var fwdmgzUpdateMarker__ = ' . '"' . esc_html__('Update marker', 'fwdmgz') . '";';
        wp_add_inline_script('fwdmgz_product_manager_script', $vars);

    	include_once "product_manager.php";
    }
    

    // CSS editor.
    public function fwdmgz_set_css_editor(){
    	if (!$this->fwdmgz_check_wp_ver()){
    		return;
    	}
    	
    	$msg = "";
    	$scroll_pos = 0;
    	
    	$css_file = plugin_dir_path(dirname(__FILE__)) . "css/global.css";
    	
	    if (!empty($_POST) && check_admin_referer("fwdmgz_css_editor_update", "fwdmgz_css_editor_nonce")){
			$handle = fopen($css_file, "w") or die("Cannot open file: " . $css_file);
			
			$data = str_replace("\\", "", $_POST["css_data"]);
			$data = str_replace("'e", "'\\e", $data);
			
			fwrite($handle, $data);
			
			$msg = esc_html__("The CSS file has been updated!", 'fwdmgz');
		}
	  			
		$handle = fopen($css_file, "r") or die("Cannot open file: " . $css_file);
    	include_once "css_editor.php";
    	fclose($handle);
    }

	
	// Shortcode.
	public function setZoomer($atts){
		
		extract(shortcode_atts(array("preset_name" => 0, "image_name" => 0, "opener" => "", "auto_open" => ""), $atts, "fwdzoomer"));


		// Preset.
    	$preset = NULL;
    	foreach ($this->_data->settings_ar as $set){
    		if ($set["name"] == $preset_name){
    			$preset = $set;
    		}
    	}

    	if (is_null($preset)){
    		return "<p class='fwdmgz-no-image'>" . esc_html__("Mega Zoom & Pan Image Zoomer with preset name ", "fwdmgz") . "<em>". esc_html__($preset_name) . "</em> " . esc_html__("does not exist!", "fwdmgz") . "</p>";
    	}
	
    	// Image.
    	$main_playlist = NULL;
    	if(empty($this->_data->main_prodcuts_ar)) return;
  
    	foreach ($this->_data->main_prodcuts_ar as $pl){
    		if ($pl["name"] == $image_name){
    			$main_playlist = $pl;
    		}
		}
    
    	if (is_null($main_playlist)){
    		return "<p class='fwdmgz-no-image'>" . esc_html__("Mega Zoom & Pan Image Zoomer with the image name ","fwdmgz") . "<em>". esc_html__($image_name) . "</em> " . esc_html__("does not exist!", "fwdmgz") . "</p>";
    	}


		// Get data and output.
		$zoomer_div = "<div id='zoomerDiv" . esc_html(FWDMGZ::$_zoomer_id) . "'></div>";		
		$FWDMGZ_constructor = $this->get_constructor($preset, $main_playlist, $image_name);
		$infoAndMarkersId = $this->getInfoWindowAndMarkers($preset, $main_playlist, $image_name);
		FWDMGZ::$_zoomer_id ++;	
	
		$rl_output = $zoomer_div . $infoAndMarkersId;

		wp_register_script( 'fwdmgz-dummy-handle-footer', '', [], '', true );
   		wp_enqueue_script( 'fwdmgz-dummy-handle-footer'  );
    	wp_add_inline_script( 'fwdmgz-dummy-handle-footer',  $FWDMGZ_constructor );

		return $rl_output; // All data was ecaped!
	}
	

	// Shortcode generator.
	public function set_custom_meta_box($post){
		if (!$this->fwdmgz_check_wp_ver()){
    		return;
    	}
		
		// Presets.
		$presetsNames = array();
		foreach ($this->_data->settings_ar as $setting){
    		$el = array(
						"id" => $setting["id"],
						"name" => $setting["name"]
				   );
    				   
    		array_push($presetsNames, $el);
    	}
    	
		// Images.
		$mainPlaylistsNames = array();
		
		if (isset($this->_data->main_prodcuts_ar)){
			foreach ($this->_data->main_prodcuts_ar as $main_playlist){
	    		$el = array(
	    				"id" => $main_playlist["id"],
	    				"name" => $main_playlist["name"]
	    			);
	    				   
	    		array_push($mainPlaylistsNames, $el);
	    	}
		}

		$vars = 'var fwdmgzPresets_ar = ' . '"' . esc_html(htmlspecialchars(json_encode($presetsNames))) . '";';
		$vars .= 'var fwdmgzPlaylists_ar = ' . '"' . esc_html(htmlspecialchars(json_encode($mainPlaylistsNames))) . '";';
		$vars .= 'var fwdmgzNoProducts__ = ' . '"' . esc_html__('No products are available.', 'fwdmgz') . '";';
		wp_add_inline_script('fwdmgz_shortcode', $vars);	

    	include_once "meta_box.php";
	}
	

	// Get constructor.
	public function get_constructor($preset, $main_playlist, $imageName) {

		$FWDMGZConstructor = "document.addEventListener('DOMContentLoaded', function(){if(document.getElementById('zoomerDiv" . esc_html(FWDMGZ::$_zoomer_id) . "')){if('" . $preset['display_type'] . "' != 'lightbox'){setupFWDZoomer" . esc_html(FWDMGZ::$_zoomer_id) . "();}}});function setupFWDZoomer" . esc_html(FWDMGZ::$_zoomer_id) . "(){window.FWDMGZ" . esc_html(FWDMGZ::$_zoomer_id) . " = new FWDM({" . "skinPath:'" . esc_url_raw($this->_dir_url) . "content/" . esc_html(esc_html(esc_html($preset['skin_path'])))  ."',parentId:'zoomerDiv" . esc_html(FWDMGZ::$_zoomer_id) . "',markersAndInfoWindowId:'markersAndInfoWindow" . esc_html(FWDMGZ::$_zoomer_id) . "',imagePath:'" . esc_url_raw($main_playlist['imageSource']) . "',displayType:'" . esc_html($preset['display_type']) . "',registrationPoint:'" . esc_html($preset['registrationPoint'])  . "',autoScale:'" . esc_html($preset['auto_scale']) . "',zoomerWidth:" . esc_html($preset['viewer_width']) . ",zoomerHeight:" . esc_html($preset['viewer_height']) . ",imageOffsetX:" . esc_html($preset['imageOffsetX']) . ",imageOffsetY:" . esc_html($preset['imageOffsetY']) . ",zoomSpeed:" . esc_html($preset['zoomSpeed']) . ",preloaderText:'" . esc_html($preset['preloaderText']) . "',initializeOnlyWhenVisible:'" . esc_html($preset['initializeOnlyWhenVisible']) . "',preloaderBackgroundSize:'" . esc_html($preset['preloaderBackgroundSize']) . "',useEntireScreen:'" . esc_html($preset['use_entire_screen']) . "',useVectorIcons:'" . esc_html($preset['useVectorIcons']) . "',hideMarkersByDefault:'" . esc_html($preset['hideMarkersByDefault']) . "',addDoubleClickSupport:'" . esc_html($preset['add_double_click_support']) . "',disableMouseWheel:'" . esc_html($preset['disable_mouse_wheel']) . "',doubleClickZoomFactor:" . esc_html($preset["doubleClickZoomFactor"]) . ",imageWidth:" . esc_html($main_playlist["image_width"]) . ",imageHeight:" . esc_html($main_playlist["image_height"]) . ",zoomFactor:" . esc_html($preset['zoom_factor']) . ",startZoomFactor:'" . esc_html($preset['start_zoom_factor']) . "',panSpeed:" . esc_html($preset['pan_speed']) . ",fullscreenBackgroundColor:'" . esc_html($preset['fullscreenBackgroundColor']) . "',backgroundColorOnZoom:'" . esc_html($preset['backgroundColorOnZoom']) . "',backgroundColor:'" . esc_html($preset['background_color'])  . "',lightBoxWidth:" . esc_html($preset['light_box_width']) . ",lightBoxHeight:" . esc_html($preset['light_box_height']) . ",lightBoxBackgroundOpacity:" . esc_html($preset['light_box_background_opacity']) . ",lightBoxBackgroundColor:'" . esc_html($preset['light_box_background_color']) . "',buttons:'" . esc_html($preset['buttons']) . "',buttonsToolTips:'" . esc_html($preset['buttons_tool_tips']) . "',controllerHorizontalPosition:'" . esc_html($preset['controllerHorizontalPosition']) . "',showControllerBackground:'" . esc_html($preset['showControllerBackground']) . "',controllerVerticalPosition:'" . esc_html($preset['controllerVerticalPosition']) . "',preloaderOffsetX:" . esc_html($preset['preloaderOffsetX']) . ",preloaderOffsetY:" . esc_html($preset['preloaderOffsetY']) . ",preloaderWidth:'" . esc_html($preset['preloaderWidth']) . "',preloaderFontColor:'" . esc_html($preset['preloaderFontColor']) . "',preloaderPosition:'" . esc_html($preset['preloaderPosition']) . "',showPreloaderProgressBar:'" . esc_html($preset['showPreloaderProgressBar']) . "',preloaderBackgroundColor:'" . esc_html($preset['preloaderBackgroundColor']) . "',preloaderProgressBarBackgroundColor:'" . esc_html($preset['preloaderProgressBarBackgroundColor']) . "',preloaderProgressBarFillColor:'" . esc_html($preset['preloaderProgressBarFillColor']) . "',preloaderWindowBackgroundOpacity:" . esc_html($preset['preloaderWindowBackgroundOpacity']) . ",inversePanDirection:'" . esc_html($preset['inverse_pan_direction']) . "',addKeyboardSupport:'" . esc_html($preset['add_keyboard_support']) . "',startSpaceBetweenButtons:" . esc_html($preset['space_between_buttons']) . ",buttonsToolTipOffsetY:" . esc_html($preset['buttons_tool_tip_offset_y']) . ",spaceBetweenButtons:" . esc_html($preset['space_between_buttons']) . ",startSpaceForScrollBarButtons:" . esc_html($preset['start_space_for_scroll_bar_buttons']) . ",startSpaceForScrollBar:" . esc_html($preset['start_space_for_scroll_bar']) . ",hideControllerDelay:" . esc_html($preset['hide_controller_delay']) . ",controllerMaxWidth:" . esc_html($preset['controller_max_width']) . ",controllerBackgroundOpacity:" . esc_html($preset['controller_background_opacity']) . ",controllerOffsetWidth:" . esc_html($preset['controllerOffsetWidth']) . ",controllerOffsetY:" . esc_html($preset['controller_offset_y']) . ",scrollBarHandlerOffsetX:" . esc_html($preset['scrollBarHandlerOffsetX']) . ",startSpaceBetweenButtons:" . esc_html($preset['startSpaceBetweenButtons']) . ",scrollBarOffsetX:" . esc_html($preset['scroll_bar_offset_x']) . ",buttonToolTipBackgroundColor:'" . esc_html($preset['buttonToolTipBackgroundColor']) . "',buttonToolTipFontColor:'" . esc_html($preset['button_tool_tip_font_color']) . "',scrollBarHandlerToolTipOffsetY:" . esc_html($preset['scroll_bar_handler_tool_tip_offset_y']) . ",zoomInAndOutToolTipOffsetY:" . esc_html($preset['zoom_in_and_out_tool_tip_offset_y']) . ",showNavigator:'" . esc_html($preset['show_navigator']) . "',navigatorWidth:'" . esc_html($preset['navigatorWidth']) . "',navigatorPosition:'" . esc_html($preset['navigator_position']) . "',navigatorOffsetX:" . esc_html($preset['navigator_offset_x']) . ",navigatorOffsetY:" . esc_html($preset['navigator_offset_y']) . ",navigatorBackgroundColor:'" . esc_html($preset['navigatorBackgroundColor']) . "',navigatorHandlerColor:'" . esc_html($preset['navigator_handler_color']) . "',navigatorBorderColor:'" . esc_html($preset['navigator_border_color']) . "',infoWindowBackgroundOpacity:" . esc_html($preset['info_window_background_opacity']) . ",infoWindowWidth:'" . esc_html($preset['infoWindowWidth']) . "',infoWindowBackgroundColor:'" . esc_html($preset['info_window_background_color']) . "',infoWindowScrollBarColor:'" . esc_html($preset['info_window_scroll_bar_color']) . "',showMarkersInfo:'no',markerToolTipOffsetY:" . esc_html($preset['marker_tool_tip_offset_y']) . ",showScriptDeveloper:'"  . esc_html($preset['showScriptDeveloper']) . "',contextMenuLabels:'" . esc_html($preset['context_menu_labels']) . "',contextMenuBorderColor:'" . esc_html($preset['contextMenuBorderColor']) . "',contextMenuSpacerColor:'" . esc_html($preset['contextMenuSpacerColor']) . "',contextMenuItemTextNormalColor:'" . esc_html($preset['contextMenuItemTextNormalColor']) . "',contextMenuItemTextSelectedColor:'" . esc_html($preset['contextMenuItemTextSelectedColor']) . "',contextMenuItemBackgroundNormalColor:'" . esc_html($preset['contextMenuItemBackgroundNormalColor']) . "',contextMenuItemBackgroundSelectedColor:'" . esc_html($preset['contextMenuItemBackgroundSelectedColor']) . "',contextMenuItemDisabledColor:'" . esc_html($preset['contextMenuItemDisabledColor']) . "'});};";// All dynamic content was escaped!

		
		return $FWDMGZConstructor;
    }
    
    // Get markers.
    public function getInfoWindowAndMarkers($preset, $main_playlist, $imageName){
    	
		if(empty($this->_data->main_prodcuts_ar)){
			return;
		} 

		$allowed_tags = wp_kses_allowed_html('post');
    	$allowed_tags['iframe'] = array(
			'src'             => array(),
			'height'          => array(),
			'width'           => array(),
			'frameborder'     => array(),
			'allowfullscreen' => array(),
		);
		
		$main_product_str = '';
		$main_product_str .= "<div id='markersAndInfoWindow" . esc_html(FWDMGZ::$_zoomer_id) . "' class='fwdmgz-data'>";
		$main_product_str .= "<div data-info=''>" . wp_kses($main_playlist['infoWindowText'], $allowed_tags) . "</div>";
	
		// Add markers.
		$main_product_str .=  "<ul data-markers='' class='fwdmgz-image'>";		
		foreach ($main_playlist['markers'] as $marker){
			foreach ($this->_data->main_markers_ar as $markerData){
				if(esc_html($markerData['name']) == $marker['text']){
					if($markerData["type"] == "link"){
						$main_product_str .= "<li data-marker-type='"  . esc_html($markerData['type']) . "' data-show-after-zoom-factor='" . esc_html($markerData['dataZoomAfterFactor']) . "' data-show-after-zoom-factor='" . esc_html($markerData['dataZoomAfterFactor']) . "' data-marker-url='" . esc_url_raw($markerData['url']) . "' data-marker-target='" . esc_html($markerData['target']) . "' data-marker-id='fwdmgz" . esc_html($markerData['name']) .  "' data-reg-point='" . esc_html($markerData['regpoint'])  . "' data-marker-width='" . esc_html($preset['marker_width']) .  "' data-marker-height='" . esc_html($preset['marker_height']) . "' data-tooltip-offset-x='" .esc_html($marker['offsetX']) . "' data-marker-left=\"" . esc_html($marker['x']) . "\" data-marker-top=\"" . esc_html($marker['y']) .  "\"  data-tool-tip-label=\"" . wp_kses($markerData['text'], $allowed_tags) . "\" data-marker-normal-state-path='" . esc_url_raw($this->_dir_url) . "content/" . esc_html($preset['skin_path']) . "/marker3.png" . "' data-marker-selected-state-path='" . esc_url_raw($this->_dir_url) . "content/" . esc_html($preset['skin_path']) . "/marker3-rollover.png" . "'></li>";
					}else if($markerData["type"] == "tooltip-plus"){
						$main_product_str .= "<li data-marker-type='"  . esc_html($markerData['type']) . "' data-show-after-zoom-factor='" . esc_html($markerData['dataZoomAfterFactor']) . "' data-show-after-zoom-factor='" . esc_html($markerData['dataZoomAfterFactor']) . "' data-marker-id='fwdmgz" . esc_html($markerData['name']) . "' data-reg-point='" . esc_html($markerData['regpoint']) . "' data-marker-window-width='" . $markerData['window_width'] . "' data-marker-width='" . esc_html($preset['marker_width']) .  "' data-marker-height='" . esc_html($preset['marker_height']) . "' data-tooltip-offset-x='" .esc_html($marker['offsetX']) . "' data-marker-left=\"" . esc_html($marker['x']) . "\" data-marker-top=\"" . esc_html($marker['y']) . "\" data-marker-normal-state-path='" . esc_url_raw($this->_dir_url) . "content/" . esc_html($preset['skin_path']) . "/marker1.png" . "' data-marker-selected-state-path='" . esc_url_raw($this->_dir_url) . "content/" . esc_html($preset['skin_path']) . "/marker1-rollover.png" . "'>" .  wp_kses($markerData['text'], $allowed_tags) . "</li>";
					}else if($markerData["type"] == "tooltip-play"){
						$main_product_str .= "<li data-marker-type='"  . esc_html($markerData['type']) . "' data-show-after-zoom-factor='" . esc_html($markerData['dataZoomAfterFactor']) . "' data-show-after-zoom-factor='" . esc_html($markerData['dataZoomAfterFactor']) . "' data-marker-id='fwdmgz" . esc_html($markerData['name']) . "' data-reg-point='" . esc_html($markerData['regpoint']) . "' data-marker-window-width='" . $markerData['window_width'] . "' data-marker-width='" . esc_html($preset['marker_width']) .  "' data-marker-height='" . esc_html($preset['marker_height']) . "' data-tooltip-offset-x='" .esc_html($marker['offsetX']) . "' data-marker-left=\"" . esc_html($marker['x']) . "\" data-marker-top=\"" . esc_html($marker['y']) . "\" data-marker-normal-state-path='" . esc_url_raw($this->_dir_url) . "content/" . esc_html($preset['skin_path']) . "/marker4.png" . "' data-marker-selected-state-path='" . esc_url_raw($this->_dir_url) . "content/" . esc_html($preset['skin_path']) . "/marker4-rollover.png" . "'>" .  wp_kses($markerData['text'], $allowed_tags) . "</li>";
					}else if($markerData["type"] == "infowindow"){
						$main_product_str .= "<li data-marker-type='"  . esc_html($markerData['type']) . "' data-show-after-zoom-factor='" . esc_html($markerData['dataZoomAfterFactor']) . "' data-show-after-zoom-factor='" . esc_html($markerData['dataZoomAfterFactor']) . "' data-marker-id='fwdmgz" . esc_html($markerData['name']) . "' data-reg-point='" . esc_html($markerData['regpoint']) . "' data-marker-width='" . esc_html($preset['marker_width']) . "' data-tooltip-offset-x='" .esc_html($marker['offsetX']) .  "' data-marker-height='" . esc_html($preset['marker_height']) . "' data-marker-left=\"" . esc_html($marker['x']) . "\" data-marker-top=\"" . esc_html($marker['y']) . "\"  data-tool-tip-label=\"" . esc_html($markerData['name']) . "\" data-marker-normal-state-path='" . esc_url_raw($this->_dir_url) . "content/" . esc_html($preset['skin_path']) . "/marker2.png" . "' data-marker-selected-state-path='" . esc_url_raw($this->_dir_url) . "content/" . esc_html($preset['skin_path']) . "/marker2-rollover.png" . "'>" .  wp_kses($markerData['text'], $allowed_tags) . "</li>";
					}
				}
			}
			
		}
		$main_product_str .=  "</ul>";
		$main_product_str .=  "</div>";
    	return $main_product_str; // All data was ecaped!
    }


    // Set menu links.
    public static function fwdmgz_set_action_links($links){
		$settings_link = "<a href='" . get_admin_url(null, "admin.php?page=fwdmgz-general-settings") . "'>" . esc_html__("Settings", "mgz") . "</a>";
   		array_unshift($links, $settings_link);
   		
   		return $links;
	}

    // Check WP version.
    private function fwdmgz_check_wp_ver(){
	    global $wp_version;
		
		if (version_compare($wp_version, FWDMGZ::MIN_WP_VER) <= 0){
			esc_html_e("The Megazoom plugin requires WordPress ", "fwdmgz") . esc_html__(FWDMGZ::MIN_WP_VER) .   esc_html__(" or newer.","fwdmgz") . "<a href='http://codex.wordpress.org/Updating_WordPress'>" .  esc_html__("Please update!","fwdmgz") . "</a>";
			return false;
		}
		return true;
	}


	// Clean function for names/labels.
	private function fwdmgz_clean($string) {
		$string = preg_replace('/"/', '\'', $string);
	   	return preg_replace('/[\[\]\&\'\/<>|\\\\]/', '', $string);
	}
}

?>