/**
 * Shortcode metabox.
 *
 * @package fwdmgz
 * @since fwdmgz 1.0
 */

jQuery(document).ready(function($){

	'use strict';

	var sid;
	var pid;

	// Get data array.
	fwdmgzPresets_ar = unescapeHtml(fwdmgzPresets_ar);
  	if(fwdmgzPresets_ar == 'null'){
		fwdmgzPresets_ar = []
	}else{
		fwdmgzPresets_ar = JSON.parse(fwdmgzPresets_ar);
	}
  	if(!fwdmgzPresets_ar) fwdmgzPresets_ar = [];


  	fwdmgzPlaylists_ar = unescapeHtml(fwdmgzPlaylists_ar);
  	if(fwdmgzPlaylists_ar == 'null'){
		fwdmgzPlaylists_ar = []
	}else{
		fwdmgzPlaylists_ar = JSON.parse(fwdmgzPlaylists_ar);
	}
  	if(!fwdmgzPlaylists_ar) fwdmgzPlaylists_ar = [];
	
	$.each(fwdmgzPresets_ar, function(i, el){
		$("#fwdmgz_presets_list").append("<option value='" + el.name + "'>" + el.name + "</option>");
	});

	$("#fwdmgz_presets_list").change(function(){
		var presetId = $("#fwdmgz_presets_list option:selected").val();
		$("#fwdmgz_shortcode").val(getShortcode());
	});
	
	$("#fwdmgz_playlists_list").change(function(){
		pid = $("#fwdmgz_playlists_list option:selected").val();
		$("#fwdmgz_shortcode").val(getShortcode());
	});
	
	$("#rl_item_auto_open").change(function(){
		autoopen = $("#fwdrl_presets_list option:selected").val();
		$("#fwdmgz_shortcode").val(getShortcode());
	});
	
	$("#mgz_item_auto_open").change(function(){
		$("#fwdmgz_shortcode").val(getShortcode());
	});
	
	
	$('.fwdMGZInputFleds').each(function() {
	   var elem = $(this);

	   // Save current value of element
	   elem.data('oldVal', elem.val());

	   // Look for changes in the value
	   elem.bind("propertychange change click keyup input paste", function(event){

		  	// If value has changed...
		  	if (elem.data('oldVal') != elem.val()) {

		  	// Updated stored value
		  	elem.data('oldVal', elem.val());
		  
		   $("#fwdmgz_shortcode").val(getShortcode());
		 }
	   });
	});
	
	
	function setShortodeIntext(){
		getShortcode();
		if(fwdmgzPlaylists_ar.length > 0){
			$("#fwdmgz_shortcode").val('[fwdzoomer preset_name="' + sid + '" image_name="' + pid + '"]');
			$("#fwdmgz_shortcode").show();
		}else{
			$("#fwdmgz_shortcode").hide();
		}
	}
	
	$("#fwdzoomer_div").hide();
	
	if (fwdmgzPlaylists_ar.length > 0){
		
		$.each(fwdmgzPlaylists_ar, function(i, el){
			$("#fwdmgz_playlists_list").append("<option value='" + el.name + "'>" + el.name + "</option>");
		});

		$("#fwdmgz_playlists_list").change(function(){
			var playlistId = $("#fwdmgz_playlists_list option:selected").val();
			$("#fwdmgz_shortcode").val(getShortcode());
		});
		
	}else{
		var td = $("#fwdmgz_playlists_list").parent();
		
		$("#fwdmgz_playlists_list").remove();
		td.append("<em class='fwdmgz-no-products'>No images are available.</em>");
		$("#fwdmgz_presets_list").prop("disabled", true);
		$("#fwdmgz_presets_list").css("cursor", "default");
		$("#fwdmgz_shortcode_btn").prop("disabled", true);
		$("#fwdmgz_shortcode_btn").css("cursor", "default");
		$("#id_or_class_input").prop("disabled", true);
		$("#id_or_class_input").css("cursor", "default");
	}
	
	$("#fwdmgz_shortcode_btn").click(function(){	
		addShortcodeFinal();
		return false;
	});
	
	function addShortcodeFinal(){
			var shortcode = getShortcode();
			
			if (typeof tinymce != "undefined"){
			    var editor = tinymce.get("content");
			    
			    if (editor && (editor instanceof tinymce.Editor) && ($("textarea#content:hidden").length != 0)) {
			        editor.selection.setContent(shortcode);
			        editor.save({no_events: true});
			    }else{
					var text = $("textarea#content").val();
					var select_pos1 = $("textarea#content").prop("selectionStart");
					var select_pos2 = $("textarea#content").prop("selectionEnd");
					
					var new_text = text.slice(0, select_pos1) + shortcode + text.slice(select_pos2);
					
					$("textarea#content").val(new_text);
			    } 
			}else{
				var text = $("textarea#content").val();
				var select_pos1 = $("textarea#content").prop("selectionStart");
				var select_pos2 = $("textarea#content").prop("selectionEnd");
				
				var new_text = text.slice(0, select_pos1) + shortcode + text.slice(select_pos2);
				
				$("textarea#content").val(new_text);
			}
			
			$("#fwdzoomer_div").hide();
			$("#fwdzoomer_div").fadeIn(600);
			$("#fwdzoomer_div").html("The shortcode has been added!");
			
			return false;
	}
	
	
	function getShortcode(){
		sid = $("#fwdmgz_presets_list option:selected").val();
		pid = $("#fwdmgz_playlists_list option:selected").val();
		var fwdmgz_shortcode = '[fwdzoomer preset_name="' + sid + '" image_name="' + pid + '"]';
		
		return fwdmgz_shortcode;
	}
	
	sid = $("#fwdmgz_presets_list").val();
	pid = $("#fwdmgz_playlists_list").val();
	setShortodeIntext();


	// Utils.
	function escapeHtml(str) {
        var map = {
            "&": "&amp;",
            "<": "&lt;",
            ">": "&gt;",
            "\"": "&quot;",
            "'": "&#039;"
        };
        str = str.replace(/'/g, "\"");
        return str.replace(/[&<>"']/g, function(m) { return map[m]; });
    }

    function unescapeHtml(str) {
        var map = {
            "&amp;": "&",
            "&lt;": "<",
            "&gt;": ">",
            "&quot;": "\"",
            "&#039;": "'"
        };
        return str.replace(/(&amp;|&lt;|&gt;|&quot;|&#039;)/g, function(m) { return map[m]; });
    }

    function removeFirstAndLastChar(str){
        str = str.substring(1);
        str = str.slice(0, -1);
        return str;
    }
});