/**
 * Image manager.
 *
 * @package fwdmgz
 * @since fwdmgz 1.0
 */

jQuery(document).ready(function($){

	'use strict';
	
	var image_width = 0;
	var image_height = 0;
	var cur_image_name = 0;
	var curMarkersAr;

	// Get data array.
	fwdmgzProductsAr = unescapeHtml(fwdmgzProductsAr);
  	if(fwdmgzProductsAr == 'null'){
		fwdmgzProductsAr = []
	}else{
		fwdmgzProductsAr = JSON.parse(fwdmgzProductsAr);
	}
  	if(!fwdmgzProductsAr) fwdmgzProductsAr = [];
  
	fwdmgzpvMarkersAr = unescapeHtml(fwdmgzpvMarkersAr);
	if(fwdmgzpvMarkersAr == 'null'){
		fwdmgzpvMarkersAr = []
	}else{
		fwdmgzpvMarkersAr = JSON.parse(fwdmgzpvMarkersAr);
	}
  	if(!fwdmgzpvMarkersAr) fwdmgzpvMarkersAr = [];
		
	$(".fwd-prodcut").mouseover(function(){
		$(this).addClass("pr_over");
		$(this).find(".pl-header").css("color", "#212121");
	});
	
	$(".fwd-prodcut").mouseout(function(){
		$(this).removeClass("pr_over");
		$(this).find(".pl-header").css("color", "#555555");
	});
	
	var imgPath = iconsPath + "normal-icon.png";
	var img = "<img src='" + imgPath + "'>";
	
	$(".prodcut > h3").prepend(img);
	
	$(".image-header .ui-accordion-header-icon").css("left", "22px");

	$(".images").sortable({
        axis: "x,y",
        handle: ".image-header",
        start: startItemesOrder,
        update: updateItemesOrder
    });
	
	$(".fwd-image").mouseover(function(){
		$(this).addClass("image_over");
		$(this).find(".image-header").css("color", "#212121");
	});
	
	$(".fwd-image").mouseout(function(){
		$(this).removeClass("image_over");
		$(this).find(".image-header").css("color", "#555555");
	});
	
	if ($("#main_prodcuts .image-count").length > 0){
		$("#mp_em").hide();
	}
	
	$("img").fwdTooltip({
    });
	
	var totalImages = fwdmgzProductsAr.length;
	var totalItems;
	var imagesAr;
	var tempMarkersAr;
	var totalMarkers;
	
	for(var i=0; i<totalImages; i++){
		
		tempMarkersAr = fwdmgzProductsAr[i]['markers'];
		
		for(var k=0; k< fwdmgzProductsAr[i]['markers'].length; k++){
			if(chackIfHasItemInArray(fwdmgzpvMarkersAr, tempMarkersAr[k]['text']) == -1){
				tempMarkersAr.splice(k, 1);
				k--;
			}
		}
	}
	
	function chackIfHasItemInArray(array, prop){
		var length = array.length;
		for(var i=0; i<length; i++){
			if(array[i]['name'] === prop) return i;
		};
		return -1;
	};
	
	function startPlaylistsOrder(ev, ui){
		var allMpItems = $(this).sortable("toArray");	
		curImageId = allMpItems.indexOf($(ui.image).attr("id"));
	}
	
	function updatePlaylistsOrder(ev, ui){
		var allMpItems = $(this).sortable("toArray");
   		newPlOrderId = allMpItems.indexOf($(ui.image).attr("id"));
   		
   		var curItem = fwdmgzProductsAr.splice(curImageId, 1)[0];
   	    fwdmgzProductsAr.splice(newPlOrderId, 0, curItem);
	};
	
	function startItemesOrder(ev, ui){
		var allItemItems = $(this).sortable("toArray");
		curItemOrderId = allItemItems.indexOf($(ui.image).attr("id"));
	}
	
	function updateItemesOrder(ev, ui){
		var allItemItems = $(this).sortable("toArray");
   		newItemOrderId = allItemItems.indexOf($(ui.image).attr("id"));
		
   		var allPlItems = $("#main_prodcuts").sortable("toArray");
   		var plParent = $(this).closest(".prodcut");
		
   		curImageId = allPlItems.indexOf($(plParent).attr("id"));
		
   		var curItem = fwdmgzProductsAr[curImageId].images.splice(curItemOrderId, 1)[0];

		fwdmgzProductsAr[curImageId].images.splice(newItemOrderId, 0, curItem);
	}
	
    function checkLength(tips, el, prop, min, max){
      	if ((el.val().length > max) || (el.val().length < min)){
        	el.addClass("ui-state-error");
        	updateTips(tips, "Length of " + prop + " must be between " + min + " and " + max + ".");
        	
        	return false;
      	}else{
        	return true;
      	}
	}
	
    function checkIfIntegerAndLength(tips, el, prop, min, max){
    	var int_reg_exp = /-?[0-9]+/;
    	var str = el.val();
    	var res = str.match(int_reg_exp);
    	
    	if (res && (res[0] == str)){
    		if ((el.val().length > max) || (el.val().length < min)){
            	el.addClass("ui-state-error");
				updateTips(tips, "Length of " + prop + " must be between " + min + " and " + max + ".");
            	return false;
          	}else{
            	return true;
          	}
        }else{
        	el.addClass("ui-state-error");
        	updateTips(tips, "The " + prop + " field value must be an integer.");
        	return false;
        }
	}
	

	function updateTips(tips, txt){
	    tips.text(txt).addClass("ui-state-highlight");

	    setTimeout(function(){
	    	tips.removeClass("ui-state-highlight", 1500);
	    }, 500);
	    
	    tips.addClass("fwd-error");
	}
	
	// Image dialogs.
	$("#add_main_prodcut_btn").click(function(e){
		e.preventDefault();
        $("#add-image-dialog").dialog("open");
    });
	
	var curImageId;
	var newPlOrderId;
	var image_name = $("#image_name");
	var pr_source = $("#pr_source");
	var allFieldsPl = $([]).add(image_name).add(pr_source);
	var image_name_edit = $("#image_name_edit");
    var pr_type_edit = $("#pr_type_edit");
	var pr_source_edit = $("#pr_source_edit");
	var allFieldsPlEdit = $([]).add(image_name_edit).add(pr_source_edit);
	var image_name = $("#image_name");
    var image_source = $("#image_source");
	var image_large_source = $("#image_large_source");
	var showAds = false;
	var allFieldsItem = $([]).add(image_name).add(image_source);
	var newItem;
	var imageId;
	var added;
	var isAdded;

	$("#add-image-dialog").dialog({
		autoOpen: false,
		width: 640,
	    height: 640,
	    dialogClass: "fwdmgz",
	    modal: true,
	    buttons:[{
	        text:fwdmgzAddImage_,
	        click:function() {
	         	var fValid = true;
				added = true;
	         	var tips = $("#add_image_tips");
	         	
	          	allFieldsItem.removeClass("ui-state-error");
				
				for(var i=0; i<fwdmgzProductsAr.length; i++){
					if(fwdmgzProductsAr[i].name == image_name.val()){
						image_name.addClass("ui-state-error");
						updateTips(tips, "The image name must be unique");
						fValid = false;
						return;
					}
				}
				
	          	fValid = fValid && checkLength(tips, image_name, "image name", 1, 64);
	       		fValid = fValid && checkLength(tips, image_source, "image source", 1, 256);
	       		
	          	if (fValid){
	          		var pid = $("#main_prodcuts .image-count").length;
					
	          		var plsIdsAr = [];
	          		
	          		if (pid > 0){
	          			$.each(fwdmgzProductsAr, function(i, el){
							plsIdsAr.push(el.id);
						});
    	          		for (var i=0; i<fwdmgzProductsAr.length; i++){
    	          			if($.inArray(i, plsIdsAr) == -1){
    	          				pid = i;
    	          				break;
    	          			}
    	          		}
	          		}else{
	          			$("#mp_em").hide();
	          		}	
						
					$("#main_prodcuts").prepend("<div id='" + image_name.val().replace(/"/g, "'") + "' class='main-image-holder image-count'>"
						+ "<h3 class='image-header-sort image-header'><span>" + image_name.val().replace(/"/g, "'") + "</span></h3>"
						+ "<img src='" + $("#thumb_source").attr("src") + "' class='fwdmgz-img' id='image" + image_name.val().replace(/"/g, "'") + "_img'></img>"
						+ "<button class='edit_image_btn' id='" + image_name.val().replace(/"/g, "'") + "_edit_btn'>" + fwdmgzEditImage_ + "</button>"
						+ "<button class='delete_image_btn' id='" + image_name.val().replace(/"/g, "'") + "_del_btn'>" + fwdmgzDeleteImage_ + "</button>"
					+ "</div>");
	          		
	          		$(".edit_image_btn").click(function(e){
						e.preventDefault();
				
						var temp_cur_image_id =  $(this).attr("id");
						cur_image_name = temp_cur_image_id.substr(0, temp_cur_image_id.length -9);
						for(var i=0; i<fwdmgzProductsAr.length; i++){
							if(fwdmgzProductsAr[i]['name'] == cur_image_name){
								curImageId = i;
								break;
							}
						}
						
						$("#edit-image-dialog").dialog("open");
      			    });
	          		
	          		$(".delete_image_btn").click(function(e){
						e.preventDefault();
					
      					var temp_cur_image_id =  $(this).attr("id");
						cur_image_name = temp_cur_image_id.substr(0, temp_cur_image_id.length -8)
      					
      			        $("#delete-image-dialog").dialog("open");
      			    });
					
					var newPl;
				
					newPl ={
						id:pid,
						name: image_name.val().replace(/"/g, "'"),
						imageSource:image_source.val().replace(/"/g, "'"),
						image_width:image_width,
						image_height:image_height,
						markers:curMarkersAr,
						infoWindowText:getInfoText()
					};
					
					fwdmgzProductsAr.unshift(newPl);

					setInfoText("");
					
		            $(this).dialog("close");
	         	}else{
	          		$("#add-image-dialog").scrollTop(0);
	          	}
	        }},
	        {
	        text:fwdmgzCancel_,
	        click: function(){
				allFieldsItem.removeClass("ui-state-error");
				$("#add_image_tips").removeClass("fwd-error");
				$(this).dialog("close");
	        }}
	    ],
	    close: function(){
			if(!added){
				allFieldsItem.removeClass("ui-state-error");
				$("#add_image_tips").removeClass("fwd-error");
			}
			added = false;
	    },
	    open: function(){
			$("#add_marker").attr("disabled", true);
	    	$("#image_name").val("");
	    	$("#image_source").val("");
			$("#image_source").attr("disabled", true);
		    $("#add_image_tips").text("The image name and source path are required.");
			$("#thumb_source").attr("src", "");
			addType = "addItem";
			$("#markers, #markers_edit").empty();
			curMarkersAr = [];
			$('.ui-widget-overlay').addClass('fwdmgz');
			
			isAdded = true;
		}
	});

	$(".add_image_btn").click(function(e){
		e.preventDefault();
		var reg_exp = /pl[0-9]+_/;
		cur_image_name = parseInt($(this).attr("id").match(reg_exp)[0].slice(2, -1));
        $("#add-image-dialog").dialog("open");
    });
	
	var image_name_edit = $("#image_name_edit");
    var image_source_edit = $("#image_source_edit");
    $(".fwd_editor_class").height(181);	
	
	var showAdsEdit = false;
    var allFieldsItemEdit = $([]).add(image_name_edit).add(image_source_edit);

	$("#edit-image-dialog").dialog({
		autoOpen: false,
		width: 640,
	    height: 640,
	    dialogClass: "fwdmgz",
	    modal: true,
	    buttons:[{
	        text:fwdmgzUpdateImage_,
	        click: function(){
	         	var fValid = true;
	         	var tips = $("#edit_image_tips");
				var tempName = fwdmgzProductsAr[curImageId].name;
	         	
	          	allFieldsItemEdit.removeClass("ui-state-error");
				
				for(var i=0; i<fwdmgzProductsAr.length; i++){
					if(fwdmgzProductsAr[i].name == image_name_edit.val() && tempName != image_name_edit.val()){
						image_name_edit.addClass("ui-state-error");
						updateTips(tips, "The image name must be unique");
						fValid = false;
						return;
					}
				}
				$("#edit_image_tips").removeClass("fwd-error");
				$("#edit_image_tips").val("The image name and image source path are required")
				fValid = fValid && checkLength(tips, image_name_edit, "image name", 1, 64);
	       		fValid = fValid && checkLength(tips, image_source_edit, "image source", 1, 256);
				
	          	if (fValid){
					var elId = document.getElementById(cur_image_name).firstChild;
				
	          		elId.innerHTML = image_name_edit.val().replace(/"/g, "'");
				
	          		fwdmgzProductsAr[curImageId].name = image_name_edit.val().replace(/"/g, "'");	
					fwdmgzProductsAr[curImageId].imageSource = image_source_edit.val().replace(/"/g, "'");
					fwdmgzProductsAr[curImageId].image_width = image_width;
					fwdmgzProductsAr[curImageId].image_height = image_height;
					fwdmgzProductsAr[curImageId].infoWindowText = getInfoTextEdit();
					
					var child = document.getElementById("image" + cur_image_name + "_img");
					
					child.src = image_source_edit.val().replace(/"/g, "'")
				
		            $(this).dialog("close");
	         	}else{
	          		$("#edit-image-dialog").scrollTop(0);
	          	}
	        }},
	        {
	       	text:fwdmgzCancel_,
	        click: function(){
	        	$(this).dialog("close");
	        }}
	    ],
	    close: function(){
		    allFieldsItemEdit.removeClass("ui-state-error");
		    $("#edit_image_tips").removeClass("fwd-error");
	    },
	    open: function(){
			
			if(fwdmgzpvMarkersAr && fwdmgzpvMarkersAr.length > 0){
				$("#add_marker_edit").attr("disabled", false);
			}else{
				$("#add_marker_edit").attr("disabled", true);
			}
			
			$("#image_source_edit").attr("disabled", true);
	    	$("#image_name_edit").val(fwdmgzProductsAr[curImageId].name);
			$("#image_source_edit").val(fwdmgzProductsAr[curImageId].imageSource);
			
			setInfoTextEdit(fwdmgzProductsAr[curImageId].infoWindowText);
			$(".fwd_editor_class").height(181);	
			$("#thumb_source_edit").attr("src", fwdmgzProductsAr[curImageId].imageSource);
			
			curMarkersAr = fwdmgzProductsAr[curImageId].markers;
			showAdsEdit = false;
			curMarkersAr = fwdmgzProductsAr[curImageId].markers;
			$("#markers, #markers_edit").empty();
		
			if(curMarkersAr){
				for(var i=0; i<curMarkersAr.length; i++){
					$("#markers_edit").append("<div id='marker" + i + "' class='marker-image'>"
						+ "<h3 class='marker-header'><span>" + curMarkersAr[i].text + "</span></h3>"
						+ "<button class='edit_marker_btn' id='marker" + i + "_edit_btn'>" + fwdmgzEditMarker_ + "</button>"
						+ "<button class='delete_marker_btn' id='marker" + i + "_del_btn'>" + fwdmgzDeleteMarker_ + "</button>"
					+ "</div>");
				}
				
				for(var i=0; i<curMarkersAr.length; i++){
					curMarkersAr[i].id = i;
				}
				
				var imgPath = iconsPath + "marker-icon.png";
				var img = "<img src='" + imgPath + "'>";
					
				$(".marker-image > h3").prepend(img);
				
				$(".marker-image").mouseover(function(){
					$(this).addClass("image_over");
					$(this).find(".marker-header").css("color", "#212121");
				});
				
				$(".marker-image").mouseout(function(){
					$(this).removeClass("image_over");
					$(this).find(".marker-header").css("color", "#555555");
				});
			
				$(".delete_marker_btn").click(function(e){
					e.preventDefault();
					var reg_exp2 = /marker[0-9]+_/;
					cur_marker_id = parseInt($(this).attr("id").match(reg_exp2)[0].slice(6, -1));
					$("#delete-marker-dialog").dialog("open");
				}); 
				
				$(".edit_marker_btn").click(function(e){
					e.preventDefault();
					var reg_exp2 = /marker[0-9]+_/;
					cur_marker_id = parseInt($(this).attr("id").match(reg_exp2)[0].slice(6, -1));

					var x = curMarkersAr[cur_marker_id].x;
					var y = curMarkersAr[cur_marker_id].y;
					var offsetX = curMarkersAr[cur_marker_id].offsetX;
					var name = curMarkersAr[cur_marker_id].text;
				
					markerFinalX = x;
					markerFinalY = y;
					isMarkerEdit = true;
					updateMarkerImage(x, y, offsetX, name);
					$("#add_marker_dialog").dialog("open");
				});
			}
			
			if(fwdmgzProductsAr[curImageId].image_width != 0){
				image_width = fwdmgzProductsAr[curImageId].image_width;
				image_height = fwdmgzProductsAr[curImageId].image_height;
			}
		
			isAdded = false;
			addType = "editItem";
			$('.ui-widget-overlay').addClass('fwdmgz');
		}
	});

	
	// Add bulk images.
	var custom_bullk;
	var attachment;

	$("#add_bulk_btn").click(function(e){
		e.preventDefault();
		openBulkUploader(e)
    });

	function openBulkUploader(e){
        e.preventDefault();
 
        // If the uploader object has already been created, reopen the dialog.
        if (custom_bullk){
            custom_bullk.open();
            return;
        }
      
        // Extend the wp.media object.
        custom_bullk = wp.media.frames.file_frame = wp.media(
        {
            title: "Choose multiple images",
            button:
            {
                text: fwdmgzAddImage_
            },library:
            {
            	type: "image"
            },
            multiple: true
        });
 		
        //When a file is selected, grab the URL and set it as the text field's value
        custom_bullk.on("select", function(){
            attachment = custom_bullk.state().get("selection").toJSON();   

			var images_ar = [];
			
			for(var i = 0; i<attachment.length; i++){
				images_ar.push({
					title:attachment[i].title, 
					url:attachment[i].url,
					width:attachment[i].width,
					height:attachment[i].height
				});
			}
			
			
			var columns = ['title'];
			var NUMBER_GROUPS = /(-?\d*\.?\d+)/g;
			var naturalSort = function (a, b, columnname) {
			  var a_field1 = a[columnname],
				  b_field1 = b[columnname],
				  aa = String(a_field1).split(NUMBER_GROUPS),
				  bb = String(b_field1).split(NUMBER_GROUPS),
				  min = Math.min(aa.length, bb.length);

			  for (var i = 0; i < min; i++) {
				var x = parseFloat(aa[i]) || aa[i].toLowerCase(),
					y = parseFloat(bb[i]) || bb[i].toLowerCase();
				if (x < y) return -1;
				else if (x > y) return 1;
			  }
			  return 0;
			};

			images_ar.sort(function(a, b) {
			  var result;
			  for (var i = 0; i < columns.length; i++) {
				result = naturalSort(a, b, columns[i]);
				if (result !== 0) return result; // or -result for decending
			  }
			  return 0; //If both are exactly the same
			});
			
		
			for(var i = 0; i<images_ar.length; i++){
				var isDuplicate = false;
				
				for(var j=0; j<fwdmgzProductsAr.length; j++){
					if(fwdmgzProductsAr[j].imageSource == images_ar[i].url){
						isDuplicate = true;
					}
				}
			
				if(!isDuplicate){
					var imageId = fwdmgzProductsAr.length;
				
	          		var imageId = images_ar[i]['title'];
	          		
					addBulkImages(imageId, images_ar[i].url, images_ar[i].width, images_ar[i].height);
				}
			}
        });
 
        //Open the uploader dialog
        custom_bullk.open();
    };

    function addBulkImages(imageId, url, width, height){
    
    	$("#main_prodcuts").prepend("<div id='" + imageId.replace(/"/g, "'") + "' class='main-image-holder image-count'>"
			+ "<h3 class='image-header-sort image-header'><span>" + imageId.replace(/"/g, "'") + "</span></h3>"
			+ "<img src='" + url + "' class='fwdmgz-img' id='image" + imageId + "_img'></img>"
			+ "<button class='edit_image_btn' id='" + imageId.replace(/"/g, "'") + "_edit_btn'>" + fwdmgzEditImage_ + "</button>"
			+ "<button class='delete_image_btn' id='" + imageId.replace(/"/g, "'") + "_del_btn'>" + fwdmgzDeleteImage_ + "</button>"
		+ "</div>");
  		
  		$(".edit_image_btn").click(function(e){
			e.preventDefault();
			var temp_cur_image_id =  $(this).attr("id");
			cur_image_name = temp_cur_image_id.substr(0, temp_cur_image_id.length -9);
			for(var i=0; i<fwdmgzProductsAr.length; i++){
				if(fwdmgzProductsAr[i]['name'] == cur_image_name){
					curImageId = i;
					break;
				}
			}
			$("#edit-image-dialog").dialog("open");
		});
  		
  		$(".delete_image_btn").click(function(e){
			e.preventDefault();
			var temp_cur_image_id =  $(this).attr("id");
			cur_image_name = temp_cur_image_id.substr(0, temp_cur_image_id.length -8)
	        $("#delete-image-dialog").dialog("open");
	    });
		
		var newPl;
	
		newPl ={
			id:imageId,
			name: imageId.replace(/"/g, "'"),
			imageSource:url,
			image_width:width,
			image_height:height,
			markers:[],
			infoWindowText:""
		};
	
		fwdmgzProductsAr.unshift(newPl);

		$("#mp_em").hide();
    }
	

    // Markers.
	var addType;
	$("#marker_x").prop('disabled', true);
	$("#marker_y").prop('disabled', true);
	
	$.each(fwdmgzpvMarkersAr, function(i, el){
		$("#select_markers").append("<option value='" + el.name + "'>" + el.name + "</option>");
	});
	
	
	
	$("#add_marker, #add_marker_edit").click(function(e){
		$("#add_marker_dialog").dialog("open");
		return false;
	});
	
	var cur_marker_id;
	var containerWidth = 620;
	var containerHeight = 480;
	var markerFinalX = 0;
	var markerFinalY = 0;
	var markerOffsetX = 0;
	var finalX = 0;
	var finalY = 0;
	var totalScale;
	var markerId;
	var isMarkerEdit;
	var markersPositionInfo_sdo;
	
	setupMarkerPosition();
	
	$("#add_marker_dialog").dialog({
		autoOpen: false,
		width: 650,
	    height: 650,
	    dialogClass: "fwdmgz",
	    modal: true,
	    buttons:[{
	        text:fwdmgzAddMarker__,
	        click: function(){
					
				$(this).dialog("close");
				stopToMoveMarker();
				
				if(!isMarkerEdit){
					curMarkersAr.push({
						id:500,
						x:markerFinalX,
						y:markerFinalY,
						offsetX:parseInt($('#offset_x').val()),
						text:$("#select_markers option:selected").text(),
						name:$("#select_markers").val()
					})
				
					$("#markers, #markers_edit").empty();
					for(var i=0; i<curMarkersAr.length; i++){
						if(addType == "addItem"){
							$("#markers").append("<div id='marker" + i + "' class='marker-image'>"
								+ "<h3 class='marker-header'><span>" + curMarkersAr[i].text + "</span></h3>"
								+ "<button class='edit_marker_btn' id='marker" + i + "_edit_btn'>" + fwdmgzEditMarker_ + "</button>"
								+ "<button class='delete_marker_btn' id='marker" + i + "_del_btn'>" + fwdmgzDeleteMarker_ + "</button>"
							+ "</div>");
							
						}else if(addType == "editItem"){
							$("#markers_edit").append("<div id='marker" + i + "' class='marker-image'>"
								+ "<h3 class='marker-header'><span>" + curMarkersAr[i].text + "</span></h3>"
								+ "<button class='edit_marker_btn' id='marker" + i + "_edit_btn'>" + fwdmgzEditMarker_ + "</button>"
								+ "<button class='delete_marker_btn' id='marker" + i + "_del_btn'>" + fwdmgzDeleteMarker_ + "</button>"
							+ "</div>");
							
						}
					}
					
					for(var i=0; i<curMarkersAr.length; i++){
						curMarkersAr[i].id = i;
					}
					
					var imgPath = iconsPath + "marker-icon.png";
					var img = "<img src='" + imgPath + "'>";
						
					$(".marker-image > h3").prepend(img);
					
					$(".marker-image").mouseover(function(){
						$(this).addClass("image_over");
						$(this).find(".marker-header").css("color", "#212121");
					});
					
					$(".marker-image").mouseout(function(){
						$(this).removeClass("image_over");
						$(this).find(".marker-header").css("color", "#555555");
					});
					
					
				}else{
					curMarkersAr[cur_marker_id].x = markerFinalX;
					curMarkersAr[cur_marker_id].y = markerFinalY;
					curMarkersAr[cur_marker_id].offsetX = parseInt($('#offset_x').val());
				}

				$(".edit_marker_btn").click(function(e){
					e.preventDefault();
					var reg_exp2 = /marker[0-9]+_/;
					cur_marker_id = parseInt($(this).attr("id").match(reg_exp2)[0].slice(6, -1));

					var x = curMarkersAr[cur_marker_id].x;
					var y = curMarkersAr[cur_marker_id].y;
					var offsetX = curMarkersAr[cur_marker_id].offsetX;
					var name = curMarkersAr[cur_marker_id].text;
					
					markerFinalX = x;
					markerFinalY = y;
					markerOffsetX = offsetX;
					isMarkerEdit = true;
					updateMarkerImage(x, y, offsetX, name);
				
					$("#add_marker_dialog").dialog("open");
				});
				
				$(".delete_marker_btn").click(function(e){
					e.preventDefault();
					var reg_exp2 = /marker[0-9]+_/;
					cur_marker_id = parseInt($(this).attr("id").match(reg_exp2)[0].slice(6, -1));
					$("#delete-marker-dialog").dialog("open");
				});
				$('.ui-widget-overlay').addClass('fwdmgz');
	        }},
	        {
	        text:fwdmgzCancel_,
	        click: function(){
	        	$(this).dialog("close");
				setTimeout(function(){
					isMarkerEdit = false;
				},50)
				stopToMoveMarker()
	        }}
	    ],
	    close: function(){
			setTimeout(function(){
				isMarkerEdit = false;
			},50)
			stopToMoveMarker();
		},
	    open: function(){
			if(!isMarkerEdit){
				markerFinalX = 0;
				markerFinalY = 0;
				markerOffsetX = 0;
				updateMarkerImage();
			}
			$('.ui-widget-overlay').addClass('fwdmgz');
		}
	});
	
	$(".delete_marker_btn").click(function(e){
		e.preventDefault();
		var reg_exp2 = /marker[0-9]+_/;
		cur_marker_id = parseInt($(this).attr("id").match(reg_exp2)[0].slice(6, -1));
		$("#delete-marker-dialog").dialog("open");
	});
	
	$("#delete-marker-dialog").dialog({
		autoOpen: false,
		width: 300,
	    height: 160,
	    dialogClass: "fwdmgz",
	    modal: true,
	    buttons:[{
	        text: fwdmgzYes_,
	        click: function(){
				
				var allMmarkers = [];
				$.each($("#markers_edit .marker-image"), function(i, el){
					var reg_exp = /marker[0-9]+_/;
					var marker_id = parseInt($(el).attr("id").substr(6));
					allMmarkers.push(marker_id);
				});
			
				var tempMarkerDataAr
				var curMarkerId = allMmarkers.indexOf(cur_marker_id);
				if(fwdmgzProductsAr[curImageId].markers.length > 0){
					fwdmgzProductsAr[curImageId].markers.splice(curMarkerId, 1);
					tempMarkerDataAr = fwdmgzProductsAr[curImageId].markers
				}else{
					curMarkersAr.splice(cur_marker_id, 1);
					tempMarkerDataAr = curMarkersAr;
				}
		   		
				$("#marker" + cur_marker_id).remove();

				if(tempMarkerDataAr){
					for(var i=0; i<tempMarkerDataAr.length; i++){
						tempMarkerDataAr[i].id = i;
					}
					var i= 0;
					$.each($("#markers_edit .marker-image"), function(i, el){
						$(el).attr("id", "marker" + i);
						$(el).find(".edit_marker_btn").attr("id", "marker" + i + "_edit_btn");
						$(el).find(".delete_marker_btn").attr("id", "marker" + i + "_delete_btn");
						i++;
					});
				}
		   		
		        $(this).dialog("close");
	        }},
	        {
	        text: fwdmgzNo_,
	        click: function(){
	        	$(this).dialog("close");
	        }}
	    ]
	});
	
	function updateMarkerImage(x, y, offsetX, name){
		
		if(x != undefined){
			$("#marker_x").val(x);
		}else{
			$("#marker_x").val(0);
		}
		
		if(y != undefined){
			$("#marker_y").val(y);
		}else{
			$("#marker_y").val(0);
		} 
	
		if(offsetX != undefined){
			$("#offset_x").val(offsetX);
			if(isNaN(offsetX)) $("#offset_x").val(0);
		}else{
			$("#offset_x").val(0);
		} 
		
		if(name != undefined){
			$("#select_markers").val(name);
		}
		
		if(isMarkerEdit){
			$("#select_markers").attr("disabled", true);
		}else{
			$("#select_markers").attr("disabled", false);
		}
		
		if($("#thumb_source").attr("src").length != 0 && isAdded){
			$("#markerImage").attr("src", $("#thumb_source").attr("src"));
		}else if($("#thumb_source_edit").attr("src").length != 0 && !isAdded){
			$("#markerImage").attr("src", $("#thumb_source_edit").attr("src"));
		}
		
		var scX = containerWidth/image_width;
		var scY = containerHeight/image_height;
			
		if(scX < scY){
			totalScale = scX;
		}else{
			totalScale = scY;
		}

		if(totalScale > 1) totalScale = 1;
		
		var finalWidth = Math.round(totalScale * image_width);
	    var finalHeight = Math.round(totalScale * image_height);
		finalX =  Math.round((containerWidth - finalWidth)/2);
		finalY =  Math.round((containerHeight - finalHeight)/2);
		
		$("#markerImage").css({top: finalY, left: finalX});
		$("#markerImage").width(finalWidth);
		$("#markerImage").height(finalHeight);
		
		setTimeout(startToMoveMarker, 500);
	}
	
	function setupMarkerPosition(){
		markersPositionInfo_sdo = new FWDMSimpleDisplayObject("div");
		markersPositionInfo_sdo.setDisplay("inline-block");
		markersPositionInfo_sdo.getStyle().fontSmoothing = "antialiased";
		markersPositionInfo_sdo.getStyle().webkitFontSmoothing = "antialiased";
		markersPositionInfo_sdo.getStyle().textRendering = "optimizeLegibility";
		markersPositionInfo_sdo.getStyle().padding = "6px";
		markersPositionInfo_sdo.getStyle().fontFamily = "Arial";
		markersPositionInfo_sdo.getStyle().fontSize= "12px";
		markersPositionInfo_sdo.getStyle().lineHeight = "20px";
		markersPositionInfo_sdo.getStyle().color = "#000000";
		markersPositionInfo_sdo.setBkColor("#FFFFFF");
		document.getElementById("markerImageHolder").appendChild(markersPositionInfo_sdo.screen);
	}
	
	function startToMoveMarker(){
		if(window.addEventListener){
			window.addEventListener("mousemove", showMarkersInfoPosition);
			window.addEventListener ("mousewheel", showMarkersInfoPosition);
			window.addEventListener('DOMMouseScroll', showMarkersInfoPosition);
			window.addEventListener("click", addMarkerClick);
		}else if(document.attachEvent){
			document.attachEvent("onmousemove", showMarkersInfoPosition);
			document.attachEvent("onmousewheel", showMarkersInfoPosition);
			document.attachEvent("onclick", addMarkerClick);
		}
	}
	
	function stopToMoveMarker(){
		if(window.removeEventListener){
			window.removeEventListener("mousemove", showMarkersInfoPosition);
			window.removeEventListener ("mousewheel", showMarkersInfoPosition);
			window.removeEventListener('DOMMouseScroll', showMarkersInfoPosition);
			window.removeEventListener("click", addMarkerClick);
		}else if(document.detachEvent){
			document.detachEvent("onmousemove", showMarkersInfoPosition);
			document.detachEvent("onmousewheel", showMarkersInfoPosition);
			document.detachEvent("onclick", addMarkerClick);
		}
	}
	
	var globalX;
	var globalY;
	var localX;
	var localY;
	function showMarkersInfoPosition(e){
		var viewportMouseCoordinates = FWDMUtils.getViewportMouseCoordinates(e);		
		globalX = document.getElementById("markerImageHolder").getBoundingClientRect().left;
		globalY = document.getElementById("markerImageHolder").getBoundingClientRect().top;
		
		localX = viewportMouseCoordinates.screenX - globalX;
		localY = viewportMouseCoordinates.screenY - globalY;
		
		
		if(FWDMUtils.hitTest(document.getElementById("markerImageHolder"), viewportMouseCoordinates.screenX, viewportMouseCoordinates.screenY)){
			var tempMarkerFinalX = parseInt((localX - finalX) * (1/totalScale));
			var tempMarkerFinalY = parseInt((localY - finalY) * (1/totalScale));
			
			var infoFinalX = localX + 10;
			var infoFinalY = localY + 10;
			markersPositionInfo_sdo.setInnerHTML("x:" + "<font color='#FF0000'>" + tempMarkerFinalX + "</font>" + " y:" + "<font color='#FF0000'>" + tempMarkerFinalY + "</font>");
			var infoWidth = markersPositionInfo_sdo.getWidth();
			var infoHeight = markersPositionInfo_sdo.getHeight();
				
			if(infoFinalX + infoWidth > containerWidth){
				infoFinalX = infoFinalX - infoWidth - 10;
			}
				
			if(infoFinalY + infoHeight > containerHeight){
				infoFinalY = infoFinalY - infoHeight - 10;
			}
			
			markersPositionInfo_sdo.setX(infoFinalX);
			markersPositionInfo_sdo.setY(infoFinalY);
		}
	}
	
	function addMarkerClick(e){
		var viewportMouseCoordinates = FWDMUtils.getViewportMouseCoordinates(e);
		if(FWDMUtils.hitTest(document.getElementById("markerImageHolder"), viewportMouseCoordinates.screenX, viewportMouseCoordinates.screenY)){
			markerFinalX = parseInt((localX - finalX) * (1/totalScale));
			markerFinalY = parseInt((localY - finalY) * (1/totalScale));
			$("#marker_x").val(markerFinalX);
			$("#marker_y").val(markerFinalY);
		}
	}
	
	function setItemDescriptionEdit(str){
		if (typeof tinyMCE !== "undefined" && tinyMCE.get("imagedescriptionedit")){
	    	tinyMCE.get("imagedescriptionedit").setContent(str);
	    }
	    
	    $("#imagedescriptionedit").val(str);
	}
	
	function getItemDescriptionEdit(){
		var image_description_edit;
		
		if (typeof tinyMCE !== "undefined" && tinyMCE.get("imagedescriptionedit")){
			if ($("#wp-imagedescriptionedit-wrap").hasClass("tmce-active")){
				image_description_edit = tinyMCE.get("imagedescriptionedit").getContent();
				
				if (image_description_edit.length < 1){
					image_description_edit = $("#imagedescriptionedit").val();
				}
			}else{
				image_description_edit = $("#imagedescriptionedit").val();
			}
	    }else{
			image_description_edit = $("#imagedescriptionedit").val();
		}
		
        return image_description_edit.replace(/"/g, "'").replace(/\n/g, "");
	}
	
	$(".edit_image_btn").click(function(e){
		e.preventDefault();
				
		var temp_cur_image_id =  $(this).attr("id");
		cur_image_name = temp_cur_image_id.substr(0, temp_cur_image_id.length -9);
		for(var i=0; i<fwdmgzProductsAr.length; i++){
			if(fwdmgzProductsAr[i]['name'] == cur_image_name){
				curImageId = i;
				break;
			}
		}
		
		$("#edit-image-dialog").dialog("open");
    });
	
	$("#delete-image-dialog").dialog({
		autoOpen: false,
		width: 300,
	    height: 160,
	    dialogClass: "fwdmgz",
	    modal: true,
	    buttons:{
	        "Yes": function(){
				
				var allPlItems = [];
				$.each($("#main_prodcuts .image-count"), function(i, el){
					var image_id = $(el).attr("id")
					allPlItems.push(image_id);
				});
				
				var curImageId = allPlItems.indexOf(cur_image_name);
			
				fwdmgzProductsAr.splice(curImageId, 1);
				document.getElementById("main_prodcuts").removeChild(document.getElementById(cur_image_name))
				
				if ($("#main_prodcuts .image-count").length == 0){
	            	$("#mp_em").show();
	            }
				
		        $(this).dialog("close");
	        },
	        "No": function(){
	        	$(this).dialog("close");
	        }
	    }
	});
	
	$(".delete_image_btn").click(function(e){
		e.preventDefault();
	
		var temp_cur_image_id =  $(this).attr("id");
		cur_image_name = temp_cur_image_id.substr(0, temp_cur_image_id.length -8)
	
        $("#delete-image-dialog").dialog("open");
    });

	
	// Upload image thumb
	var custom_uploader4;
	var curScroll4;
    
    $("#upload_thumb_button").click(function(e) {
        e.preventDefault();
		
		curScroll = $("#add-image-dialog").scrollTop();
 
        // If the uploader object has already been created, reopen the dialog.
        if (custom_uploader4){
            custom_uploader4.open();
            return;
        }
        
        // Extend the wp.media object.
        custom_uploader4 = wp.media.frames.file_frame = wp.media({
            title: fwdmgzChooseImage_,
            button:
            {
                text: fwdmgzAddImage_
            },library:
            {
            	type: "image"
            },
            multiple: false
        });
 
        // When a file is selected, grab the URL and set it as the text field's value.
        custom_uploader4.on("select", function(){
            attachment = custom_uploader4.state().get("selection").first().toJSON();
            
            $("#image_thumb").val(attachment.url);
			$("#upload_thumb").attr("src", attachment.url);
        });
 
        //Open the uploader dialog
        custom_uploader4.open();
		
		custom_uploader4.on("close", function(){
            $("#add-image-dialog").scrollTop(curScroll);
        });
    });
	

	// Image custom uploader.
	var custom_uploader;
	var curScroll;
    
    $("#upload_image_source_button").click(function(e) {
        e.preventDefault();
		
		curScroll = $("#add-image-dialog").scrollTop();
		$("#add-image-dialog").css({'display':'none'});
 
        // If the uploader object has already been created, reopen the dialog.
        if (custom_uploader){
            custom_uploader.open();
            return;
        }
        
        // Extend the wp.media object.
        custom_uploader = wp.media.frames.file_frame = wp.media({
            title: fwdmgzChooseImage_,
            button:
            {
                text: fwdmgzAddImage_
            },library:
            {
            	type: "image"
            },
            multiple: false
        });
 
        // When a file is selected, grab the URL and set it as the text field's value.
        custom_uploader.on("select", function(){
            attachment = custom_uploader.state().get("selection").first().toJSON();
          
            $("#image_source").val(attachment.url);
			if(attachment.url.indexOf(".jpg") != -1
			  || attachment.url.indexOf(".jpeg") != -1
			  ||  attachment.url.indexOf(".png") != -1
			  ||  attachment.url.indexOf(".webp") != -1
			){
				$("#thumb_source").attr("src", attachment.url);
			}else{
				$("#thumb_source").attr("src", "");
			}
			
			if(fwdmgzpvMarkersAr && fwdmgzpvMarkersAr.length > 0){
				$("#add_marker").attr("disabled", false);
			}
			
			image_width = parseInt(attachment.width);
			image_height = parseInt(attachment.height);
			$("#add-image-dialog").css({'display':'block'});
        });
 
        // Open the uploader dialog.
        custom_uploader.open();
		custom_uploader.on("close", function(){
            $("#add-image-dialog").scrollTop(curScroll);
            $("#add-image-dialog").css({'display':'block'});
        });
    });
	
	
	// Upload large source.
	var custom_uploader22;
	var curScroll;
    
    $("#upload_image_large_source_button").click(function(e) {
        e.preventDefault();
		
		curScroll = $("#add-image-dialog").scrollTop();
 
        // If the uploader object has already been created, reopen the dialog.
        if (custom_uploader22){
            custom_uploader22.open();
            return;
        }
        
        // Extend the wp.media object.
        custom_uploader22 = wp.media.frames.file_frame = wp.media({
            title: fwdmgzChooseImage_,
            button:
            {
                text: fwdmgzAddImage_
            },library:
            {
            	type: "image"
            },
            multiple: false
        });
 
        // When a file is selected, grab the URL and set it as the text field's value.
        custom_uploader22.on("select", function(){
            attachment = custom_uploader22.state().get("selection").first().toJSON();
            
            $("#image_large_source").val(attachment.url);
			if(attachment.url.indexOf(".jpg") != -1
			  || attachment.url.indexOf(".jpeg") != -1
			  ||  attachment.url.indexOf(".png") != -1
			  ||  attachment.url.indexOf(".webp") != -1
			){
				$("#thumb_large_source").attr("src", attachment.url);
			}else{
				$("#thumb_large_source").attr("src", "");
			}
			
        });
 
        // Open the uploader dialog.
        custom_uploader22.open();
		custom_uploader22.on("close", function(){
            $("#add-image-dialog").scrollTop(curScroll);
        });
    });
	
	// Upload large edit.
	var custom_uploader333;
	var curScroll;
    
    $("#upload_image_large_source_button_edit").click(function(e) {
        e.preventDefault();
		
		curScroll = $("#add-image-dialog_edit").scrollTop();
 
        // If the uploader object has already been created, reopen the dialog.
        if (custom_uploader333){
            custom_uploader333.open();
            return;
        }
        
        // Extend the wp.media object.
        custom_uploader333 = wp.media.frames.file_frame = wp.media({
            title: fwdmgzChooseImage_,
            button:
            {
                text: fwdmgzAddImage_
            },library:
            {
            	type: "image"
            },
            multiple: false
        });
 
        // When a file is selected, grab the URL and set it as the text field's value.
        custom_uploader333.on("select", function(){
            attachment = custom_uploader333.state().get("selection").first().toJSON();
            
            $("#image_large_source_edit").val(attachment.url);
			if(attachment.url.indexOf(".jpg") != -1
			  || attachment.url.indexOf(".jpeg") != -1
			  ||  attachment.url.indexOf(".png") != -1
			  ||  attachment.url.indexOf(".webp") != -1
			){
				$("#thumb_large_source_edit").attr("src", attachment.url);
			}else{
				$("#thumb_large_source_edit").attr("src", "");
			}
        });
 
        // Open the uploader dialog.
        custom_uploader333.open();
		
		custom_uploader333.on("close", function(){
            $("#add-image-dialog_edit").scrollTop(curScroll);
        });
    });
	
	// Upload image thumb edit.
	var custom_uploader5;
	var curScroll5;
    
    $("#upload_thumb_button_edit").click(function(e) {
        e.preventDefault();
		
		curScroll5 = $("#add-image-dialog").scrollTop();
 
        // If the uploader object has already been created, reopen the dialog.
        if (custom_uploader5){
            custom_uploader5.open();
            return;
        }
        
        // Extend the wp.media object.
        custom_uploader5 = wp.media.frames.file_frame = wp.media({
            title: fwdmgzChooseImage_,
            button:
            {
                text: fwdmgzAddImage_
            },library:
            {
            	type: "image"
            },
            multiple: false
        });
 
        // When a file is selected, grab the URL and set it as the text field's value.
        custom_uploader5.on("select", function(){
            attachment = custom_uploader5.state().get("selection").first().toJSON();
            
            $("#image_thumb_edit").val(attachment.url);
			$("#upload_thumb_edit").attr("src", attachment.url);
        });
 
        // Open the uploader dialog.
        custom_uploader5.open();
		
		custom_uploader5.on("close", function(){
            $("#add-image-dialog-edit").scrollTop(curScroll5);
        });
    });
	
    // Image custom uploader edit.
	var custom_uploader_edit;
	var curScrollEdit;
    
    $("#upload_image_button_edit").click(function(e){
        e.preventDefault();
		
		curScrollEdit = $("#edit-image-dialog").scrollTop();
		$("#edit-image-dialog").css({'display':'none'});
 
        // If the uploader object has already been created, reopen the dialog.
        if (custom_uploader_edit){
            custom_uploader_edit.open();
            return;
        }
        
        // Extend the wp.media object.
        custom_uploader_edit = wp.media.frames.file_frame = wp.media(
        {
            title: "Choose image",
            button:
            {
                text: fwdmgzAddImage_
            },library:
            {
            	type: "image"
            },
            multiple: false
        });
 
        // When a file is selected, grab the URL and set it as the text field's value.
        custom_uploader_edit.on("select", function(){
            attachment = custom_uploader_edit.state().get("selection").first().toJSON();   
            $("#image_source_edit").val(attachment.url);
			
			if(attachment.url.indexOf(".jpg") != -1
			  || attachment.url.indexOf(".jpeg") != -1
			  || attachment.url.indexOf(".png") != -1
			  || attachment.url.indexOf(".webp") != -1
			){
				$("#thumb_source_edit").attr("src", attachment.url);
			}else{
				$("#thumb_source_edit").attr("src", "");
			}
			
			image_width = parseInt(attachment.width);
			image_height = parseInt(attachment.height);

			$("#edit-image-dialog").css({'display':'block'});
        });
 
        // Open the uploader dialog.
        custom_uploader_edit.open();
		
		custom_uploader_edit.on("close", function() {
            $("#edit-image-dialog").scrollTop(curScrollEdit);
            $("#edit-image-dialog").css({'display':'block'});
        });
    });
	
	function setInfoText(str){
		if (tinyMCE.get("thtext")) {
	    	tinyMCE.get("thtext").setContent(str);
	    } 
	    $("#thtextedit").val(str);
	}
	
	function getInfoText(){
		var th_text;
		
		if (tinyMCE.get("thtext")) {
			if ($("#wp-thtext-wrap").hasClass("tmce-active")){
				th_text = tinyMCE.get("thtext").getContent();
				
				if (th_text.length < 1){
					th_text = $("#thtext").val();
				}
			}else{
				th_text = $("#thtext").val();
			}
	    }else{
			th_text = $("#thtext").val();
		}

        return th_text.replace(/"/g, "'").replace(/\n/g, "");
	}
	
	function setInfoTextEdit(str){
		if (tinyMCE.get("thtextedit")) {
	    	tinyMCE.get("thtextedit").setContent(str);
	    } 
	    $("#thtextedit").val(str);
	}
	
	function getInfoTextEdit(){
		var th_text;
		
		if (tinyMCE.get("thtextedit")) {
			if ($("#wp-thtextedit-wrap").hasClass("tmce-active")){
				th_text = tinyMCE.get("thtextedit").getContent();
				
				if (th_text.length < 1){
					th_text = $("#thtextedit").val();
				}
			}else{
				th_text = $("#thtextedit").val();
			}
	    }else{
			th_text = $("#thtextedit").val();
		}

        return th_text.replace(/"/g, "'").replace(/\n/g, "");
	}
	
	
    $("#update_btn").click(function(){
    	$("#product_data").val(JSON.stringify(fwdmgzProductsAr));
    });

    function updateTips(tips, txt){
	    tips.text(txt).addClass("ui-state-highlight");

	    setTimeout(function(){
	    	tips.removeClass("ui-state-highlight", 1500);
	    }, 500);
	    
	    tips.addClass("fwd-error");
	}

    function escapeHtml(str) {
	    var map = {
	        "&": "&amp;",
	        "<": "&lt;",
	        ">": "&gt;",
	        "\"": "&quot;",
	    "'": "&#039;"
	    };
	    str = str.replace(/'/g, "\"");
	    return str.replace(/[&<>"']/g, function(m) { return map[m]; });
	}

	function unescapeHtml(str) {
	    var map = {
	        "&amp;": "&",
	        "&lt;": "<",
	        "&gt;": ">",
	        "&quot;": "\"",
	        "&#039;": "'"
	    };
	    return str.replace(/(&amp;|&lt;|&gt;|&quot;|&#039;)/g, function(m) { return map[m]; });
	}
})