<div class="fwdmgz-dummy-wp">
	<?php
		$settings = array("media_buttons" => false, "editor_class" => "fwd_editor_class", 'tinymce' => true);
		wp_editor("", "thtext22", $settings);
	?>
</div>

<div id="add-marker-dialog" title="<?php esc_html_e('Add new marker','fwdmgz'); ?>">
	<p id="add_pr_tips"><?php esc_html_e('The name field is required.','fwdmgz'); ?></p>

	<div>
    	<label for="pr_name"><?php esc_html_e('Name:','fwdmgz'); ?></label>
    	<input type="text" id="pr_name" class="text ui-widget-content ui-corner-all fwdmgz-name">

		<div class="fwdmgz-type">
			<label for="marker_type"><?php esc_html_e('Type:','fwdmgz'); ?></label>
    		<select id="marker_type" class="ui-corner-all">
    			<option value="link"><?php esc_html_e('Link','fwdmgz'); ?></option>
    			<option value="tooltip-plus"><?php esc_html_e('Tooltip plus','fwdmgz'); ?></option>
		   		<option value="tooltip-play"><?php esc_html_e('Tooltip play','fwdmgz'); ?></option>
    			<option value="infowindow"><?php esc_html_e('Infowindow','fwdmgz'); ?></option>
    		</select>
		</div>
		
		<div class="fwdmgz-registration-point">
    		<label for="reg_point"><?php esc_html_e('Registration point:','fwdmgz'); ?></label>
    		<select id="reg_point" class="ui-corner-all">
    			<option value="center"><?php esc_html_e('Center','fwdmgz'); ?></option>
    			<option value="top"><?php esc_html_e('Top','fwdmgz'); ?></option>
    			<option value="bottom"><?php esc_html_e('Bottom','fwdmgz'); ?></option>
    			<option value="leftbottom"><?php esc_html_e('Bottom left','fwdmgz'); ?></option>
    		</select>
    		<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This represent the marker icon registration point, if the marker has a round shape set it to center, if it has a pointy up shape set it top or if it has a pointy down shape set it to bottom.','fwdmgz'); ?>">
    	</div>

    	<div id="show_after_zoom_div" class="fwdmgz-link-point">
			<label for="show_after_zoom_div"><?php esc_html_e('Show after zoom:','fwdmgz'); ?></label>
			<input type="text" id="show_after_zoom" class="text ui-widget-content ui-corner-all">
			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('A number between 0 and the specified zoom factor, if you want to show a marker after the image is zoomed for example 60% set this number to .6, this varies based on the way you want to use this.... To always show the marker set this to 0 (zero).','fwdmgz'); ?>">
		</div>
		
		<div id="link_type" class="fwdmgz-link-point">
			<label for="marker_url"><?php esc_html_e('URL:','fwdmgz'); ?></label>
			<input type="text" id="marker_url" class="text ui-widget-content ui-corner-all">
			<label for="link_target" class="link-target"><?php esc_html_e('Target:','fwdmgz'); ?></label>
			<select id="link_target" class="ui-corner-all">
				<option value="_blank"><?php esc_html_e('_blank','fwdmgz'); ?></option>
				<option value="_self"><?php esc_html_e('_self:','fwdmgz'); ?></option>
			</select>
		</div>

		<div id="marher_th" class="fwdmgz-marker-th">
			<div id="window_width_div">
				<label id="window_width_label"><?php esc_html_e('Marker window width:','fwdmgz'); ?></label>
				<input type="text" id="window_width" class="text ui-widget-content ui-corner-all">
				<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('The tooltip window width in pixels, the height will adapt based on the tooltip window HTML content.','fwdmgz'); ?>">
			</div>
			<br>
			<label>Text:</label>
			<?php $settings = array("media_buttons" => false, "wpautop" => false, "editor_class" => "fwd_editor_class", "tinymce" => false);
			wp_editor("", "thtext", $settings);?>
		</div>
  	</div>	
</div>

<div id="edit-marker-dialog" title="<?php esc_html_e('Edit marker','fwdmgz'); ?>">	
	<p id="add_pr_tips_edit"><?php esc_html_e('The name field is required.','fwdmgz'); ?></p>
	<div>
		<label for="pr_name_edit"><?php esc_html_e('Name:','fwdmgz'); ?></label>
	   	<input type="text" id="pr_name_edit" class="text ui-widget-content ui-corner-all fwdmgz-name" disabled="true">
	   	
	   	<div class="fwdmgz-type">
	   		<label for="marker_type_edit"><?php esc_html_e('Type:','fwdmgz'); ?></label>
		   	<select id="marker_type_edit" class="ui-corner-all">
		   		<option value="link"><?php esc_html_e('Link','fwdmgz'); ?></option>
    			<option value="tooltip-plus"><?php esc_html_e('Tooltip plus','fwdmgz'); ?></option>
		   		<option value="tooltip-play"><?php esc_html_e('Tooltip play','fwdmgz'); ?></option>
    			<option value="infowindow"><?php esc_html_e('Infowindow','fwdmgz'); ?></option>
		   	</select>
	   	</div>

	   	<div class="fwdmgz-registration-point">
		   	<label for="reg_point_edit"><?php esc_html_e('Registration point:','fwdmgz'); ?></label>
	   		<select id="reg_point_edit" class="ui-corner-all">
	   			<option value="center"><?php esc_html_e('Center','fwdmgz'); ?></option>
    			<option value="top"><?php esc_html_e('Top','fwdmgz'); ?></option>
    			<option value="bottom"><?php esc_html_e('Bottom','fwdmgz'); ?></option>
    			<option value="leftbottom"><?php esc_html_e('Bottom left','fwdmgz'); ?></option>
	   		</select>
	   		<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This represent the marker icon registration point, if the marker has a round shape set it to center, if it has a pointy up shape set it top or if it has a pointy down shape set it to bottom.','fwdmgz'); ?>">
	   	</div>

	   	<div id="show_after_zoom_edit_div" class="fwdmgz-link-point">
			<label for="show_after_zoom_edit"><?php esc_html_e('Show after zoom:','fwdmgz'); ?></label>
			<input type="text" id="show_after_zoom_edit" class="text ui-widget-content ui-corner-all">
			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('A number between 0 and the specified zoom factor, if you want to show a marker after the image is zoomed for example 60% set this number to .6, this varies based on the way you want to use this.... To always show the marker set this to 0 (zero).','fwdmgz'); ?>">
		</div>
   		
   		<div id="link_type_edit" class="fwdmgz-link-point">
   			<label for="marker_url_edit"><?php esc_html_e('URL:','fwdmgz'); ?></label>
   			<input type="text" id="marker_url_edit" class="text ui-widget-content ui-corner-all">
   			<label for="link_target_edit" class="link-target"><?php esc_html_e('Target:','fwdmgz'); ?></label>
   			<select id="link_target_edit" class="ui-corner-all">
   				<option value="_blank"><?php esc_html_e('_blank','fwdmgz'); ?></option>
   				<option value="_self"><?php esc_html_e('_self','fwdmgz'); ?></option>
   			</select>
   		</div>

   		<div id="marher_th_edit" class="fwdmgz-marker-th">
   			<div id="window_width_div_edit">
   				<label id="window_width_label_edit"><?php esc_html_e('Marker window width:','fwdmgz'); ?></label>
   				<input type="text" id="window_width_edit" class="text ui-widget-content ui-corner-all">
   				<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('The tooltip window width in pixels, the height will adapt based on the tooltip window HTML content.','fwdmgz'); ?>">
   			</div>
   			<br>
   			<label><?php esc_html_e('Text:','fwdmgz'); ?></label>
   			<?php
   				$settings = array("media_buttons" => false, "wpautop" => false, "editor_class" => "fwd_editor_class", "tinymce" => false);
   				wp_editor("", "thtextedit", $settings);
   			?>
	   		</div>
	</div>
</div>

<div id="delete-marker-dialog" title="<?php esc_html_e('Delete marker','fwdmgz'); ?>">
	<fieldset>
    	<label><?php esc_html_e('Are you sure you want to delete this marker?','fwdmgz'); ?></label>
  	</fieldset>
</div>

<form action="" method="post" class="fwdmgz">
	<div class="holder ui-widget ui-widget-content ui-corner-all">
		<h3>All markers:</h3>
	  	
		<div id="main_markers">
			<?php 
				$markers_str = "";
				if (isset($this->_data->main_markers_ar)){
		    		foreach ($this->_data->main_markers_ar as $pid => $marker){
						$markers_str .= "<div id='pl" . esc_html($pid) . "' class='fwd-item'>";
						$markers_str .= "<h3 class='item-header'><span>" . esc_html($marker["name"]) . "</span></h3>";
						$markers_str .= "<div>";
						$markers_str .= "<button class='edit_marker_btn' id='pl" . esc_html($pid) .  "_edit_btn'>" . esc_html__('Edit marker','fwdmgz') . "</button>";
						$markers_str .= "<button class='delete_marker_btn' id='pl" . esc_html($pid) . "_del_btn'>" . esc_html__('Delete marker','fwdmgz') . "</button>";
						$markers_str .= "</div>";
						$markers_str .= "</div>";
	    			}
					echo $markers_str;
				}
			?>
		</div>
		<em id="mp_em"><?php esc_html_e('No markers are available.', 'fwdmgz'); ?></em>
		<button id="add_main_marker_btn"><?php esc_html_e('Add new marker', 'fwdmgz'); ?></button>
  	</div>
  	<input type="hidden" id="marker_data" name="marker_data" value="">
	<input id="update_btn" type="submit" name="submit" value="<?php esc_html_e('Update markers','fwdmgz'); ?>" />
	<?php wp_nonce_field("fwdmgz_marker_manager_update", "fwdmgz_marker_manager_nonce"); ?>
</form>

<?php if(!(empty($msg))): ?>
<div class='fwd-updated'>
	<p class="fwd-updated-p">
		<?php echo esc_html($msg); ?>
	</p>
</div>
<?php endif; ?>