<fieldset class="fwdmgz ui-widget">
	<label for="skins"><?php esc_html_e('Select your preset:', 'fwdmgz'); ?></label>
    <select id="skins" class="ui-widget ui-corner-all"></select>
    <label id="preset_id" for="skins"></label>
	
	<p id="tips"><?php esc_html_e('All form fields are required.', 'fwdmgz'); ?></p>
    
</fieldset>

<form action="" method="post" class="form fwdmgz">
	<div id="tabs">
	  	<ul class="menu">
		    <li><a href="#tab1"><img src=<?php echo esc_url($iconsPath) . "tab1-icon.png" ?> ><span><?php esc_html_e('Main settings', 'fwdmgz'); ?></span></a></li>
		    <li><a href="#tab2"><img src=<?php echo esc_url($iconsPath) . "tab2-icon.png" ?> ><span><?php esc_html_e('Controller settings', 'fwdmgz'); ?></span></a></li>
			<li><a href="#tab3"><img src=<?php echo esc_url($iconsPath) . "tab3-icon.png" ?> ><span><?php esc_html_e('Navigator settings', 'fwdmgz'); ?></span></a></li>
		    <li><a href="#tab4"><img src=<?php echo esc_url($iconsPath) . "tab4-icon.png" ?> ><span><?php esc_html_e('Info window settings', 'fwdmgz'); ?></span></a></li>
			<li><a href="#tab5"><img src=<?php echo esc_url($iconsPath) . "tab5-icon.png" ?> ><span><?php esc_html_e('Context menu settings', 'fwdmgz'); ?></span></a></li>
			<li><a href="#tab6"><img src=<?php echo esc_url($iconsPath) . "tab6-icon.png" ?> ><span><?php esc_html_e('Lightbox settings', 'fwdmgz'); ?></span></a></li>
			<li><a href="#tab7"><img src=<?php echo esc_url($iconsPath) . "tab7-icon.png" ?> ><span><?php esc_html_e('Preloader settings', 'fwdmgz'); ?></span></a></li>
	  	</ul>

	  	<div id="tab1">
			<table>
				<tr>
		    		<td>
		    			<label for="name"><?php esc_html_e('Preset name:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="name" class="text ui-widget-content ui-corner-all">
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="skin_path"><?php esc_html_e('Skin type:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<select id="skin_path" class="ui-corner-all">
							<option value="skin1"><?php esc_html_e('skin1', 'fwdmgz'); ?></option>
							<option value="skin2"><?php esc_html_e('skin2', 'fwdmgz'); ?></option>
						</select>
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="display_type"><?php esc_html_e('Display type:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<select id="display_type" class="ui-corner-all">
							<option value="responsive"><?php esc_html_e('Responsive', 'fwdmgz'); ?></option>
							<option value="fullscreen"><?php esc_html_e('Full screen', 'fwdmgz'); ?></option>
							<option value="lightbox"><?php esc_html_e('Lightbox', 'fwdmgz'); ?></option>
						</select>
		    		</td>
		    	</tr>

		    	<tr>
		    		<td>
		    			<label for="initializeOnlyWhenVisible"><?php esc_html_e('Lazy loading:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<select id="initializeOnlyWhenVisible" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('Yes', 'fwdmgz'); ?></option>
							<option value="no"><?php esc_html_e('No', 'fwdmgz'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>" 
						title="<?php esc_html_e('Set this to yes if you want to initialize the zoomer only when visible in the page.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
		    	
				<tr>
		    		<td>
		    			<label for="use_entire_screen"><?php esc_html_e('Use entire screen:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<select id="use_entire_screen" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('Yes', 'fwdmgz'); ?></option>
							<option value="no"><?php esc_html_e('No', 'fwdmgz'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>" 
						title="<?php esc_html_e('If is set to yes the images will use the entire available screen, if is set to no the images will use the entire screen width and the entire screen height minus the buttons control bar height, this option is usually set to no.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>	
		    	<tr>
		    		<td>
		    			<label for="useVectorIcons"><?php esc_html_e('Use vector icons:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<select id="useVectorIcons" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('Yes', 'fwdmgz'); ?></option>
							<option value="no"><?php esc_html_e('No', 'fwdmgz'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('By default the zoomer is using .png images for the controller buttons and skin, if you want to use vector icons set this option to yes. Customizing the vector icons is done in the plugin CSS settings section.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>

		    	
				<tr>
		    		<td>
		    			<label for="add_double_click_support"><?php esc_html_e('Add double click support:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<select id="add_double_click_support" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('Yes', 'fwdmgz'); ?></option>
							<option value="no"><?php esc_html_e('No', 'fwdmgz'); ?></option>
						</select>
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="doubleClickZoomFactor"><?php esc_html_e('Double click zoom factor', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="doubleClickZoomFactor" class="input-with-icon text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="A float number from 0 to n that represents the start double click zoom factor, make sure that this feature value is not larger then the zoom factor.">
		    		</td>
		    	</tr>

				<tr>
		    		<td>
		    			<label for="disable_mouse_wheel"><?php esc_html_e('Disable mousewheel:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<select id="disable_mouse_wheel" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('Yes', 'fwdmgz'); ?></option>
							<option value="no"><?php esc_html_e('No', 'fwdmgz'); ?></option>
						</select>
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="auto_scale"><?php esc_html_e('Auto scale:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<select id="auto_scale" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('Yes', 'fwdmgz'); ?></option>
							<option value="no"><?php esc_html_e('No', 'fwdmgz'); ?></option>
						</select>
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="registrationPoint"><?php esc_html_e('Registration point:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<select id="registrationPoint" class="ui-corner-all">
							<option value="center"><?php esc_html_e('Center', 'fwdmgz'); ?></option>
							<option value="topleft"><?php esc_html_e('Top-left', 'fwdmgz'); ?></option>
						</select>
		    		</td>
		    	</tr>
		    	
				<tr>
		    		<td>
		    			<label for="viewer_width"><?php esc_html_e('Zoomer max width:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="viewer_width" class="input-with-icon text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('If the display type is responsive this is the maximum allowed width of the viewer.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="viewer_height"><?php esc_html_e('Zoomer max height:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="viewer_height" class="input-with-icon text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('If the display type is responsive this is the maximum allowed height of the viewer.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
			</table>

			<table>
				<tr>
		    		<td>
		    			<label for="imageOffsetX"><?php esc_html_e('Zoomer image offset X:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="imageOffsetX" class="input-with-icon text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('Image offset X in px.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="imageOffsetY"><?php esc_html_e('Zoomer image offset Y:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="imageOffsetY" class="input-with-icon text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('Image offset Y in px.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>

				<tr>
		    		<td>
		    			<label for="start_zoom_factor"><?php esc_html_e('Start zoom factor:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="start_zoom_factor" class="input-with-icon text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('A float number from 0 to n that represents the start zoom factor, this is useful if you want to start the wiewer with the image zoomed, make sure that this number is not larger then the zoom factor. The default value is \'default\'.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
			
				<tr>
		    		<td>
		    			<label for="zoom_factor"><?php esc_html_e('Zoom factor:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="zoom_factor" class="input-with-icon text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('The zoom factor, what this number does is to limit the image zoom for example if you have a small image with a width of 500px and you want it to be zoomed at a maximum of 1000px then set this number to 2, if you want it to zoom to a maximum of 1500px set this number to 3 and so on.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="pan_speed"><?php esc_html_e('Pan speed:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="pan_speed" class="input-with-icon text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
							title="<?php esc_html_e('A number from 1 to 100 that represents the pan speed (this number represents how many pixels the image will pan on each interval), the higher the number the faster the pan speed will be.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="zoomSpeed"><?php esc_html_e('Zoom speed:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="zoomSpeed" class="input-with-icon text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('A float from 0.1 to 1 representing the zoom speed.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>

		    	<tr>
		    		<td>
		    			<label for="hideMarkersByDefault"><?php esc_html_e('Hide markers by default:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<select id="hideMarkersByDefault" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('Yes', 'fwdmgz'); ?></option>
							<option value="no"><?php esc_html_e('No', 'fwdmgz'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('Show or not the markers first time the image is showed.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="marker_tool_tip_offset_y"><?php esc_html_e('Markers tooltip offset y:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="marker_tool_tip_offset_y" class="input-with-icon text ui-widget-content ui-corner-all">
		    		</td>
		    	</tr>

		    	<tr>
		    		<td>
		    			<label for="marker_width"><?php esc_html_e('Markers icon width:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="marker_width" class="input-with-icon text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('Markers/hotspots buttons width in px.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="marker_height"><?php esc_html_e('Markers icon height:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="marker_height" class="input-with-icon text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('Markers/hotspots buttons height in px.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="background_color"><?php esc_html_e('Background color:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input id="background_color" />
		    		</td>
		    	</tr>

		    	<tr>
		    		<td>
		    			<label for="backgroundColorOnZoom"><?php esc_html_e('Background color when zoomed:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input id="backgroundColorOnZoom" />
		    		</td>
		    	</tr>

		    	<tr>
		    		<td>
		    			<label for="fullscreenBackgroundColor"><?php esc_html_e('Background color on fullscreen:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input id="fullscreenBackgroundColor" />
		    		</td>
		    	</tr>
		    </table>
		</div>
	
		<div id="tab2">
			<table>
				<tr>
					<td>
						<label for="controllerHorizontalPosition"><?php esc_html_e('Controller horizontal position:', 'fwdmgz'); ?></label>
					</td>
					<td>
						<select id="controllerHorizontalPosition" class="ui-corner-all">
							<option value="left"><?php esc_html_e('Left', 'fwdmgz'); ?></option>
							<option value="center"><?php esc_html_e('Center', 'fwdmgz'); ?></option>
							<option value="right"><?php esc_html_e('Right', 'fwdmgz'); ?></option>
						</select>
					</td>
				</tr>
				<tr>
					<td>
						<label for="controllerVerticalPosition"><?php esc_html_e('Controller vertical position:', 'fwdmgz'); ?></label>
					</td>
					<td>
						<select id="controllerVerticalPosition" class="ui-corner-all">
							<option value="bottom"><?php esc_html_e('bottom', 'fwdmgz'); ?></option>
							<option value="top"><?php esc_html_e('Top', 'fwdmgz'); ?></option>
						</select>
					</td>
				</tr>
				<tr>
					<td>
						<label for="showControllerBackground"><?php esc_html_e('Show controller background:', 'fwdmgz'); ?></label>
					</td>
					<td>
						<select id="showControllerBackground" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('Yes', 'fwdmgz'); ?></option>
							<option value="no"><?php esc_html_e('No', 'fwdmgz'); ?></option>
						</select>
					</td>
				</tr>
				
				<tr>
					<td>
						<label for="inverse_pan_direction"><?php esc_html_e('Inverse pan direction:', 'fwdmgz'); ?></label>
					</td>
					<td>
						<select id="inverse_pan_direction" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('Yes', 'fwdmgz'); ?></option>
							<option value="no"><?php esc_html_e('No', 'fwdmgz'); ?></option>
						</select>
					</td>
				</tr> 
				<tr>
					<td>
						<label for="add_keyboard_support"><?php esc_html_e('Add keyboard support:', 'fwdmgz'); ?></label>
					</td>
					<td>
						<select id="add_keyboard_support" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('Yes', 'fwdmgz'); ?></option>
							<option value="no"><?php esc_html_e('No', 'fwdmgz'); ?></option>
						</select>
						
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('Add support for the arrows key to navigate the image once it is zoomed.', 'fwdmgz'); ?>">
					</td>
				</tr>
				<tr>
		    		<td>
		    			<label for="buttons"><?php esc_html_e('Buttons:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="buttons" class="input-with-icon text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('This options represents the buttons from the buttons bar, they are separated by \',\'. The buttons are displayed in the order in which they are listed here so you can switch the order of the buttons by modifying the list order. If you don\'t need a button just remove it from the list, for example to display only the rotate and pan buttons set this option like this:rotate, pan. If you don\'t need a controllbar lave this option empty. Available options: rotate, pan, roteteleft, rotateright, scrollbar, play, info, link, fullscreen', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
				<tr>
					<td>
						<label for="buttons_tool_tips"><?php esc_html_e('Buttons tooltips:', 'fwdmgz'); ?></label>
					</td>
					<td>
						<input type="text" id="buttons_tool_tips" class="input-with-icon text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('This options represents the buttons bar tooltips they are separated by ','. Each tooltip is related to a button so the order of tooltips must be the same with the order of buttons from the buttons option explained above, there are some buttons which requires two tootltip states like the fullscreen button, in this case the tooltip string is separated by \'/\' for example the fullscreen tooltip is formatted like this: Full screen/Normal screen. If you don\'t want to use the tooltips leave this option balnk.', 'fwdmgz'); ?>">
					</td>
				</tr>
				
				<tr>
					<td>
						<label for="startSpaceBetweenButtons"><?php esc_html_e('Start space between buttons:', 'fwdmgz'); ?></label>
					</td>
					<td>
						<input type="text" id="startSpaceBetweenButtons" class="input-with-icon text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('The space in pixels between the beginning of the buttons bar and the first button and the end of the buttons bar and the last button.', 'fwdmgz'); ?>">
					</td>
				</tr>
				<tr>
					<td>
						<label for="space_between_buttons"><?php esc_html_e('Space between buttons:', 'fwdmgz'); ?></label>
					</td>
					<td>
						<input type="text" id="space_between_buttons" class="input-with-icon text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>" 
						title="<?php esc_html_e('The space in pixels between the buttons.', 'fwdmgz'); ?>">
					</td>
				</tr>
				
				<tr>
					<td>
						<label for="start_space_for_scroll_bar_buttons"><?php esc_html_e('Start space between scrollbar buttons:', 'fwdmgz'); ?></label>
					</td>
					<td>
						<input type="text" id="start_space_for_scroll_bar_buttons" class="text input-with-icon ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('The space in pixels between the beginning of the a normal button and the zoom in or zoom out button.', 'fwdmgz'); ?>">
					</td>
				</tr>
				
				<tr>
					<td>
						<label for="start_space_for_scroll_bar"><?php esc_html_e('Start space for scrollbar:', 'fwdmgz'); ?></label>
					</td>
					<td>
						<input type="text" id="start_space_for_scroll_bar" class="text input-with-icon ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('The space in pixels between the zoom in or zoom out button and the zoom scrollbar.', 'fwdmgz'); ?>">
					</td>
				</tr>
				
				<tr>
					<td>
						<label for="hide_controller_delay"><?php esc_html_e('Controller hide delay:', 'fwdmgz'); ?></label>
					</td>
					<td>
						<input type="text" id="hide_controller_delay" class="text input-with-icon ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('The delay in seconds until the controll bar will hide after a period of inactivity.', 'fwdmgz'); ?>">
					</td>
				</tr>
			</table>
				
			<table>
				<tr>
					<td>
						<label for="controller_max_width"><?php esc_html_e('Controller max width:', 'fwdmgz'); ?></label>
					</td>
					<td>
						<input type="text" id="controller_max_width" class="text input-with-icon ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('The buttons bar allowed maximum width in pixels, for example if you want the buttons bar to expand to the maximum available width set it to a high number like 3000 pixels.', 'fwdmgz'); ?>">
					</td>
				</tr>
				<tr>
					<td>
						<label for="controller_background_opacity"><?php esc_html_e('Controller background opacity:', 'fwdmgz'); ?></label>
					</td>
					<td>
						<input type="text" id="controller_background_opacity" class="text input-with-icon ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('An integer from 0 to 1 representing the buttons bar opacity.', 'fwdmgz'); ?>">
					</td>
				</tr>
				<tr>
					<td>
						<label for="controllerOffsetWidth"><?php esc_html_e('Controller offset width:', 'fwdmgz'); ?></label>
					</td>
					<td>
						<input type="text" id="controllerOffsetWidth" class="text input-with-icon ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('Controller left and right margins in px.', 'fwdmgz'); ?>">
					</td>
				</tr>
				
				<tr>
					<td>
						<label for="controller_offset_y"><?php esc_html_e('Controller offset y:', 'fwdmgz'); ?></label>
					</td>
					<td>
						<input type="text" id="controller_offset_y" class="text input-with-icon ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('The offset in pixels on the y axis for the buttons bar, this mean that if you want to push down or up the buttons bar you can do it by modifying this number.', 'fwdmgz'); ?>">
					</td>
				</tr>
				
				<tr>
					<td>
						<label for="scroll_bar_offset_x"><?php esc_html_e('Scrollbar offset x:', 'fwdmgz'); ?></label>
					</td>
					<td>
						<input type="text" id="scroll_bar_offset_x" class="text input-with-icon ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('The offset in pixels on the x axis for the scrollbar and zoom buttons, this is useful if you want to push the scrollbar to the left or right a few pixels.', 'fwdmgz'); ?>">
					</td>
				</tr>

				<tr>
					<td>
						<label for="scrollBarHandlerOffsetX"><?php esc_html_e('Scrollbar handler offset x:', 'fwdmgz'); ?></label>
					</td>
					<td>
						<input type="text" id="scrollBarHandlerOffsetX" class="text input-with-icon ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('The offset in px for the scrollbar handler, this will allow to drag further to the left or right the scrollbar handler, is useful if the handler has a larger padding to tweek it so that visually it looks perfect.', 'fwdmgz'); ?>">
					</td>
				</tr>
				
				<tr>
					<td>
						<label for="scroll_bar_handler_tool_tip_offset_y"><?php esc_html_e('Scrollbar handler tooltip offset y:', 'fwdmgz'); ?></label>
					</td>
					<td>
						<input type="text" id="scroll_bar_handler_tool_tip_offset_y" class="text input-with-icon ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('The offset in pixels on the y axis for the scrollbar handler tooltips.', 'fwdmgz'); ?>">
					</td>
				</tr>
				
				<tr>
					<td>
						<label for="zoom_in_and_out_tool_tip_offset_y"><?php esc_html_e('Zoom in and zoom out offset y:', 'fwdmgz'); ?></label>
					</td>
					<td>
						<input type="text" id="zoom_in_and_out_tool_tip_offset_y" class="text input-with-icon ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('The offset in pixels on the y axis for the zoom buttons tooltips.', 'fwdmgz'); ?>">
					</td>
				</tr>
				
				<tr>
					<td>
						<label for="buttons_tool_tip_offset_y"><?php esc_html_e('Buttons tooltip offset y:', 'fwdmgz'); ?></label>
					</td>
					<td>
						<input type="text" id="buttons_tool_tip_offset_y" class="text input-with-icon ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('The offset in pixels on the y axis for the main buttons tooltips.', 'fwdmgz'); ?>">
					</td>
				</tr>
				<tr>
		    		<td>
		    			<label for="buttonToolTipBackgroundColor"><?php esc_html_e('Buttons tooltip background color:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input id="buttonToolTipBackgroundColor" />
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="button_tool_tip_font_color"><?php esc_html_e('Buttons tooltip font color:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input id="button_tool_tip_font_color" />
		    		</td>
		    	</tr>
			</table>
		</div>
		
		<div id="tab3">
			<table>
				<tr>
		    		<td>
		    			<label for="show_navigator"><?php esc_html_e('Show navigator:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_navigator" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('Yes', 'fwdmgz'); ?></option>
							<option value="no"><?php esc_html_e('No', 'fwdmgz'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('Disable or enable the navigator, if this option is set to no then the navigator images are not required.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="navigator_position"><?php esc_html_e('Navigator position:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<select id="navigator_position" class="ui-corner-all">
							<option value="topright"><?php esc_html_e('Top right', 'fwdmgz'); ?></option>
							<option value="topleft"><?php esc_html_e('Top left', 'fwdmgz'); ?></option>
							<option value="bottomright"><?php esc_html_e('Bottom right', 'fwdmgz'); ?></option>
							<option value="bottomleft"><?php esc_html_e('Bottom left', 'fwdmgz'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('Represents the navigator position on screeen.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>

		    	<tr>
		    		<td>
		    			<label for="navigatorWidth"><?php esc_html_e('Navigator width:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="navigatorWidth" class="text input-with-icon ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('Navigator width in px, the navigator height is set based on the image ratio so no need to specify it.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
		    	
				<tr>
		    		<td>
		    			<label for="navigator_offset_x"><?php esc_html_e('Navigator offset x:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="navigator_offset_x" class="text input-with-icon ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('A number representing the an offset in pixels for the navigator on the x axis (think of it like margins left or right).', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="navigator_offset_y"><?php esc_html_e('Navigator offset y:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="navigator_offset_y" class="text input-with-icon ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('A number representing the an offset in pixels for the navigator on the y axis (think of it like margins top or bottom).', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="navigatorBackgroundColor"><?php esc_html_e('Navigator background color:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="navigatorBackgroundColor" class="text input-with-icon ui-widget-content ui-corner-all">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="navigator_handler_color"><?php esc_html_e('Navigator handler color:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="navigator_handler_color" class="text input-with-icon ui-widget-content ui-corner-all">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="navigator_border_color"><?php esc_html_e('Navigator border color:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="navigator_border_color" class="text input-with-icon ui-widget-content ui-corner-all">
		    		</td>
		    	</tr>
				
			</table>
		</div>
	
		
		<div id="tab4">
			<table>
			
				<tr>
		    		<td>
		    			<label for="info_window_background_opacity"><?php esc_html_e('Info window background opacity:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="info_window_background_opacity" class="text input-with-icon ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('A number from 0 to 1 which represents the opacity for the info window background opacity.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
		    	
		    	<tr>
		    		<td>
		    			<label for="infoWindowWidth"><?php esc_html_e('Info window width:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="infoWindowWidth" class="text input-with-icon ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('Info window width in px.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="info_window_background_color"><?php esc_html_e('Info window background color:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input id="info_window_background_color" />
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="info_window_scroll_bar_color"><?php esc_html_e('Info window scrollbar color:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input id="info_window_scroll_bar_color" />
		    		</td>
		    	</tr>
			</table>
		</div>
		
		<div id="tab5">
			<table>
				<tr>
		    		<td>
		    			<label for="showScriptDeveloper"><?php esc_html_e('Show script developer:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<select id="showScriptDeveloper" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('Yes', 'fwdmgz'); ?></option>
							<option value="no"><?php esc_html_e('No', 'fwdmgz'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('This can be yes or no, it will add an extra entry in the context menu with a link to our site, if this does not bother you please leave it active it will help us with our work.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="context_menu_labels"><?php esc_html_e('Context menu labels:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="context_menu_labels" class="text input-with-icon ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('This options represents the context menu items they are separated by ','. Each item is related to a main button so the order must be the same with the order of buttons from the buttons option, there are some items which requires two states like the fullscreen item, in this case the string is separated by \'/\' for example the fullscreen item is formatted like this: Full screen/Normal screen. If you don\'t want to use the context menu leave this option blank like this.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
			
				<tr>
		    		<td>
		    			<label for="contextMenuBorderColor"><?php esc_html_e('Context menu border color:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input id="contextMenuBorderColor" />
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="contextMenuSpacerColor"><?php esc_html_e('Context menu spacer color:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input id="contextMenuSpacerColor" />
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="contextMenuItemTextNormalColor"><?php esc_html_e('Context menu item text normal color:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input id="contextMenuItemTextNormalColor" />
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="contextMenuItemTextSelectedColor"><?php esc_html_e('Context menu item text selected color:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input id="contextMenuItemTextSelectedColor" />
		    		</td>
		    	</tr>

		    	<tr>
		    		<td>
		    			<label for="contextMenuItemBackgroundNormalColor"><?php esc_html_e('Context menu item background normal color:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input id="contextMenuItemBackgroundNormalColor" />
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="contextMenuItemBackgroundSelectedColor"><?php esc_html_e('Context menu item background selected color:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input id="contextMenuItemBackgroundSelectedColor" />
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="contextMenuItemDisabledColor"><?php esc_html_e('Context menu item disabled color:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input id="contextMenuItemDisabledColor" />
		    		</td>
		    	</tr>
				
			</table>
		</div>
		
		<div id="tab6">
			<table>
			
				<tr>
		    		<td>
		    			<label for="light_box_width"><?php esc_html_e('Lightbox width:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="light_box_width" class="text input-with-icon ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('Maximum lightbox width in pixels.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="light_box_height"><?php esc_html_e('Lightbox height:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="light_box_height" class="text input-with-icon ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('Maximum lightbox height in pixels.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="light_box_background_opacity"><?php esc_html_e('Lightbox opacity:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="light_box_background_opacity" class="text input-with-icon ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('A number from 0 to 1 representing the lighbox background opcacity.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="light_box_background_color"><?php esc_html_e('Lightbox background color:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input id="light_box_background_color" />
		    		</td>
		    	</tr>
			</table>
		</div>
		<div id="tab7">
			<table>
				<tr>
		    		<td>
		    			<label for="preloaderText"><?php esc_html_e('Preloader text:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="preloaderText" class="text input-with-icon ui-widget-content ui-corner-all">
		    		</td>
		    	</tr>

		    	<tr>
		    		<td>
		    			<label for="preloaderPosition"><?php esc_html_e('Preloader position:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<select id="preloaderPosition" class="ui-corner-all">
							<option value="topLeft"><?php esc_html_e('Top-left', 'fwdmgz'); ?></option>
							<option value="topRight"><?php esc_html_e('Top-right', 'fwdmgz'); ?></option>
							<option value="center"><?php esc_html_e('Center', 'fwdmgz'); ?></option>
							<option value="bottomLeft"><?php esc_html_e('Bottom-left', 'fwdmgz'); ?></option>
							<option value="bottomRight"><?php esc_html_e('Bottom-right', 'fwdmgz'); ?></option>
						</select>
		    		</td>
		    	</tr>

		    	<tr>
		    		<td>
		    			<label for="preloaderOffsetX"><?php esc_html_e('Preloader offset X:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="preloaderOffsetX" class="text input-with-icon ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('The preloader padding left or right in px based on the preloader position.', 'fwdmgz'); ?>">
		    		</td>
		    		
		    	</tr>

		    	<tr>
		    		<td>
		    			<label for="preloaderOffsetY"><?php esc_html_e('Preloader offset Y:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="preloaderOffsetY" class="text input-with-icon ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('The preloader padding top or bottom in px based on the preloader position.', 'fwdmgz'); ?>">
		    		</td>
		    		
		    	</tr>

		    	<tr>
		    		<td>
		    			<label for="showPreloaderProgressBar"><?php esc_html_e('Show preloader progress bar:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<select id="showPreloaderProgressBar" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('Yes', 'fwdmgz'); ?></option>
							<option value="no"><?php esc_html_e('No', 'fwdmgz'); ?></option>
						</select>
		    		</td>
		    	</tr>

		    	<tr>
		    		<td>
		    			<label for="preloaderWidth"><?php esc_html_e('Preloader width:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="preloaderWidth" class="text input-with-icon ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('The preloader in %  for example 50% is half of the viewer width. To set the preloader bar width the same as the text width set this option to full.', 'fwdmgz'); ?>">
		    		</td>
		    		
		    	</tr>
		    	
		    	<tr>
		    		<td>
		    			<label for="preloaderBackgroundSize"><?php esc_html_e('Preloader window background size:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<select id="preloaderBackgroundSize" class="ui-corner-all">
							<option value="small"><?php esc_html_e('Small', 'fwdmgz'); ?></option>
							<option value="large"><?php esc_html_e('Large', 'fwdmgz'); ?></option>
						</select>
		    		</td>
		    	</tr>

		    	<tr>
		    		<td>
		    			<label for="preloaderWindowBackgroundOpacity"><?php esc_html_e('Preloader window background opacity:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="preloaderWindowBackgroundOpacity" class="text input-with-icon ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($toolTipImgSrc); ?>"
						title="<?php esc_html_e('The opacity for the preloader window background from 0 to 1, 0.5 means 50% opacity.', 'fwdmgz'); ?>">
		    		</td>
		    	</tr>
		    	
				<tr>
		    		<td>
		    			<label for="preloaderBackgroundColor"><?php esc_html_e('Preloader window background color:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input id="preloaderBackgroundColor" />
		    		</td>
		    	</tr>

		    	<tr>
		    		<td>
		    			<label for="preloaderFontColor"><?php esc_html_e('Preloader font color:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input id="preloaderFontColor" />
		    		</td>
		    	</tr>

		    	<tr>
		    		<td>
		    			<label for="preloaderProgressBarBackgroundColor"><?php esc_html_e('Preloader progress bar background color:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input id="preloaderProgressBarBackgroundColor" />
		    		</td>
		    	</tr>

		    	<tr>
		    		<td>
		    			<label for="preloaderProgressBarFillColor"><?php esc_html_e('Preloader progress bar fill color:', 'fwdmgz'); ?></label>
		    		</td>
		    		<td>
		    			<input id="preloaderProgressBarFillColor" />
		    		</td>
		    	</tr>
			</table>
		</div>
	</div>
	
	<input type="hidden" id="settings_data" name="settings_data" value="">
	<input id="add_btn" type="submit" name="submit" value="<?php esc_html_e('Add new preset', 'fwdmgz'); ?>" />
	<input id="update_btn" type="submit" name="submit" value="<?php esc_html_e('Update preset settings', 'fwdmgz'); ?>" />
	<input id="del_btn" type="submit" name="submit" value="<?php esc_html_e('Delete preset', 'fwdmgz'); ?>" />
	
	<?php wp_nonce_field("FWDMGZ_general_settings_update", "FWDMGZ_general_settings_nonce"); ?>
</form>

<?php if(!(empty($msg))): ?>
<div class='fwd-updated'>
	<p class="fwd-updated-p">
		<?php echo esc_html($msg); ?>
	</p>
</div>
<?php endif; ?>