/**
 * General settings.
 *
 * @package fwdmgz
 * @since fwdmgz 1.0
 */

jQuery(document).ready(function($){

	'use strict';

	var DEFAULT_SKINS_NR = 2;
	var cur_settings_obj;

	fwdmgzSettingsAr = unescapeHtml(fwdmgzSettingsAr);
    fwdmgzSettingsAr = JSON.parse(fwdmgzSettingsAr);
	
	$("#tabs").tabs();
	
	$("#contextMenuItemTextNormalColor, #contextMenuItemTextSelectedColor, #contextMenuItemBackgroundNormalColor, #contextMenuItemBackgroundSelectedColor, #contextMenuItemDisabledColor, #thumbnail_background_color, #info_window_background_color,#preloaderProgressBarFillColor, #preloaderProgressBarBackgroundColor, #fullscreenBackgroundColor, #preloaderFontColor, #background_color, #backgroundColorOnZoom, #context_menu_item_normal_color, #context_menu_item_selected_color, #contextMenuItemDisabledColor,#buttonToolTipBackgroundColor, #button_tool_tip_font_color,  #navigator_border_color, #info_window_scroll_bar_color, #contextMenuBorderColor, #timeColor, #button_background_selected_color, #button_text_normal_color, #button_text_selected_color, #combo_box_shadow_color, #preloaderBackgroundColor, #light_box_background_color, #combo_box_shadow_color, #navigatorBackgroundColor, #navigator_handler_color, #info_window_scroll_bar_color, #contextMenuBorderColor, #contextMenuSpacerColor").spectrum({
  	    color: "#5a5a5a",
  	  	chooseText: "Update",
  	  	showInitial: true,
  	  	showInput: true,
  	  	allowEmpty:true,
  	  	preferredFormat: "hex6"
  	});
	
	
	$("#tabs img").fwdTooltip({});
    
    function init(){ 
    	$.each(fwdmgzSettingsAr, function(i, el){
			$("#skins").append("<option value='" + el.id + "'>" + el.name + "</option>");
		});
    	
    	$("#skins").val(fwdmgzSetId);
    	
    	if (fwdmgzCurOrderId < DEFAULT_SKINS_NR){
    		$("#update_btn").hide();
            $("#del_btn").hide();
    	}else{
    		$("#update_btn").show();
            $("#del_btn").show();
    	}
	    
	    setSettings();
	    
	    $("#preset_id").html("ID : " + fwdmgzSetId);
	    $("#tabs").tabs("option", "active", fwdmgzTabInitId);
    }
	init();
	
	// Set settings.
    function setSettings() {
    	var settings_obj = fwdmgzSettingsAr[fwdmgzCurOrderId];
		
		// main settings
		$("#display_type").val(settings_obj.display_type);
		$("#initializeOnlyWhenVisible").val(settings_obj.initializeOnlyWhenVisible);
		$("#name").val(settings_obj.name);
		$("#skin_path").val(settings_obj.skin_path);
		$("#add_keyboard_support").val(settings_obj.add_keyboard_support);
		$("#use_as_modal").val(settings_obj.use_as_modal);
		$("#add_double_click_support").val(settings_obj.add_double_click_support);
		$("#disable_mouse_wheel").val(settings_obj.disable_mouse_wheel);
		$("#add_keyboard_support").val(settings_obj.add_keyboard_support);
		$("#show_close_button").val(settings_obj.show_close_button);
		$("#show_share_button").val(settings_obj.show_share_button);
		$("#show_zoom_button").val(settings_obj.show_zoom_button);
		$("#show_slide_show_button").val(settings_obj.show_slide_show_button);
		$("#show_slide_show_animation").val(settings_obj.show_slide_show_animation);
		$("#slide_show_delay").val(settings_obj.slide_show_delay);
		$("#hideMarkersByDefault").val(settings_obj.hideMarkersByDefault);
		$("#marker_tool_tip_offset_y").val(settings_obj.marker_tool_tip_offset_y);
		$("#marker_width").val(settings_obj.marker_width);
		$("#marker_height").val(settings_obj.marker_height);
		$("#slide_show_delay_on_mobile").val(settings_obj.slide_show_delay_on_mobile);
		$("#preloaderText").val(settings_obj.preloaderText);
		$("#zoom_factor").val(settings_obj.zoom_factor);
		$("#use_entire_screen").val(settings_obj.use_entire_screen);
		$("#useVectorIcons").val(settings_obj.useVectorIcons);
		$("#start_zoom_factor").val(settings_obj.start_zoom_factor);
		$("#auto_scale").val(settings_obj.auto_scale);
		$("#registrationPoint").val(settings_obj.registrationPoint);
		$("#doubleClickZoomFactor").val(settings_obj.doubleClickZoomFactor);
		$("#viewer_width").val(settings_obj.viewer_width);
		$("#viewer_height").val(settings_obj.viewer_height);
		$("#imageOffsetX").val(settings_obj.imageOffsetX);
		$("#imageOffsetY").val(settings_obj.imageOffsetY);
		$("#pan_speed").val(settings_obj.pan_speed);
		$("#zoomSpeed").val(settings_obj.zoomSpeed);
		$("#space_between_buttons").val(settings_obj.space_between_buttons);
		$("#buttons_offset_in").val(settings_obj.buttons_offset_in);
		$("#buttons_offset_out").val(settings_obj.buttons_offset_out);
		$("#item_border_size").val(settings_obj.item_border_size);
		$("#item_border_radius").val(settings_obj.item_border_radius);
		$("#background_opacity").val(settings_obj.background_opacity);
		$("#item_box_shadow").val(settings_obj.item_box_shadow);
		$("#preloaderBackgroundColor").spectrum("set", settings_obj.preloaderBackgroundColor != "transparent" ? settings_obj.preloaderBackgroundColor : null);
		$("#preloaderFontColor").spectrum("set", settings_obj.preloaderFontColor != "transparent" ? settings_obj.preloaderFontColor : null);
		$("#fullscreenBackgroundColor").spectrum("set", settings_obj.fullscreenBackgroundColor != "transparent" ? settings_obj.fullscreenBackgroundColor : null);	
		$("#background_color").spectrum("set", settings_obj.background_color != "transparent" ? settings_obj.background_color : null);
		$("#backgroundColorOnZoom").spectrum("set", settings_obj.backgroundColorOnZoom != "transparent" ? settings_obj.backgroundColorOnZoom : null);

		// Thumbnail settings
		$("#controllerVerticalPosition").val(settings_obj.controllerVerticalPosition);
		$("#showControllerBackground").val(settings_obj.showControllerBackground);
		$("#controllerHorizontalPosition").val(settings_obj.controllerHorizontalPosition);
		$("#preloaderFontColor").val(settings_obj.preloaderFontColor);
		$("#inverse_pan_direction").val(settings_obj.inverse_pan_direction);
		$("#add_keyboard_support").val(settings_obj.add_keyboard_support);
		$("#slide_show_auto_play").val(settings_obj.slide_show_auto_play);
		$("#controller_position_small_icon").val(settings_obj.controller_position_small_icon);
		$("#thumbnails_hover_effect").val(settings_obj.thumbnails_hover_effect);
		$("#buttons_tool_tips").val(settings_obj.buttons_tool_tips);
		$("#space_between_buttons").val(settings_obj.space_between_buttons);
		$("#start_space_for_scroll_bar_buttons").val(settings_obj.start_space_for_scroll_bar_buttons);
		$("#start_space_for_scroll_bar").val(settings_obj.start_space_for_scroll_bar);
		$("#hide_controller_delay").val(settings_obj.hide_controller_delay);
		$("#buttons").val(settings_obj.buttons);
		$("#controller_max_width").val(settings_obj.controller_max_width);
		$("#controller_background_opacity").val(settings_obj.controller_background_opacity);
		$("#controllerOffsetWidth").val(settings_obj.controllerOffsetWidth);
		$("#controller_offset_y").val(settings_obj.controller_offset_y);
		$("#scroll_bar_offset_x").val(settings_obj.scroll_bar_offset_x);
		$("#startSpaceBetweenButtons").val(settings_obj.startSpaceBetweenButtons);
		$("#scrollBarHandlerOffsetX").val(settings_obj.scrollBarHandlerOffsetX);
		$("#scroll_bar_handler_tool_tip_offset_y").val(settings_obj.scroll_bar_handler_tool_tip_offset_y);
		$("#zoom_in_and_out_tool_tip_offset_y").val(settings_obj.zoom_in_and_out_tool_tip_offset_y);
		$("#buttons_tool_tip_offset_y").val(settings_obj.buttons_tool_tip_offset_y);
		$("#link").val(settings_obj.link);
		$("#info_window_background_opacity").val(settings_obj.info_window_background_opacity);
		$("#infoWindowWidth").val(settings_obj.infoWindowWidth);
		$("#buttonToolTipBackgroundColor").spectrum("set", settings_obj.buttonToolTipBackgroundColor != "transparent" ? settings_obj.buttonToolTipBackgroundColor : null);
		$("#button_tool_tip_font_color").spectrum("set", settings_obj.button_tool_tip_font_color != "transparent" ? settings_obj.button_tool_tip_font_color : null);
		$("#navigator_border_color").spectrum("set", settings_obj.navigator_border_color != "transparent" ? settings_obj.navigator_border_color : null);

		// Description window settings.
		$("#show_navigator").val(settings_obj.show_navigator);
		$("#navigatorWidth").val(settings_obj.navigatorWidth);
		$("#navigator_position").val(settings_obj.navigator_position);
		$("#navigator_offset_x").val(settings_obj.navigator_offset_x);
		$("#navigator_offset_y").val(settings_obj.navigator_offset_y);
		$("#description_window_background_opacity").val(settings_obj.description_window_background_opacity);
		$("#description_window_position").val(settings_obj.description_window_position);
		$("#navigator_handler_color").spectrum("set", settings_obj.navigator_handler_color != "transparent" ? settings_obj.navigator_handler_color : null);
		$("#navigatorBackgroundColor").spectrum("set", settings_obj.navigatorBackgroundColor != "transparent" ? settings_obj.navigatorBackgroundColor : null);
		
		// Video and audio settings.
		$("#showScriptDeveloper").val(settings_obj.showScriptDeveloper);
		$("#context_menu_labels").val(settings_obj.context_menu_labels);
		$("#light_box_width").val(settings_obj.light_box_width);
		$("#light_box_height").val(settings_obj.light_box_height);
		$("#light_box_background_opacity").val(settings_obj.light_box_background_opacity);
		$("#info_window_background_color").spectrum("set", settings_obj.info_window_background_color != "transparent" ? settings_obj.info_window_background_color : null);
		$("#info_window_scroll_bar_color").spectrum("set", settings_obj.info_window_scroll_bar_color != "transparent" ? settings_obj.info_window_scroll_bar_color : null);
		$("#contextMenuBorderColor").spectrum("set", settings_obj.contextMenuBorderColor != "transparent" ? settings_obj.contextMenuBorderColor : null);
		$("#contextMenuSpacerColor").spectrum("set", settings_obj.contextMenuSpacerColor != "transparent" ? settings_obj.contextMenuSpacerColor : null);
		$("#contextMenuItemTextNormalColor").spectrum("set", settings_obj.contextMenuItemTextNormalColor != "transparent" ? settings_obj.contextMenuItemTextNormalColor : null);
		$("#contextMenuItemTextSelectedColor").spectrum("set", settings_obj.contextMenuItemTextSelectedColor != "transparent" ? settings_obj.contextMenuItemTextSelectedColor : null);
		$("#contextMenuItemBackgroundNormalColor").spectrum("set", settings_obj.contextMenuItemBackgroundNormalColor != "transparent" ? settings_obj.contextMenuItemBackgroundNormalColor : null);
		$("#contextMenuItemBackgroundSelectedColor").spectrum("set", settings_obj.contextMenuItemBackgroundSelectedColor != "transparent" ? settings_obj.contextMenuItemBackgroundSelectedColor : null);
		$("#contextMenuItemDisabledColor").spectrum("set", settings_obj.contextMenuItemDisabledColor != "transparent" ? settings_obj.contextMenuItemDisabledColor : null);
		$("#light_box_background_color").spectrum("set", settings_obj.light_box_background_color != "transparent" ? settings_obj.light_box_background_color : null);
		$("#preloaderProgressBarBackgroundColor").spectrum("set", settings_obj.preloaderProgressBarBackgroundColor != "transparent" ? settings_obj.preloaderProgressBarBackgroundColor : null);
		$("#preloaderProgressBarFillColor").spectrum("set", settings_obj.preloaderProgressBarFillColor != "transparent" ? settings_obj.preloaderProgressBarFillColor : null);
		$("#preloaderText").val(settings_obj.preloaderText);
		$("#preloaderPosition").val(settings_obj.preloaderPosition);
		$("#preloaderOffsetX").val(settings_obj.preloaderOffsetX);
		$("#preloaderOffsetY").val(settings_obj.preloaderOffsetY);
		$("#showPreloaderProgressBar").val(settings_obj.showPreloaderProgressBar);
		$("#preloaderWidth").val(settings_obj.preloaderWidth);
		$("#preloaderBackgroundSize").val(settings_obj.preloaderBackgroundSize);
		$("#preloaderWindowBackgroundOpacity").val(settings_obj.preloaderWindowBackgroundOpacity);
    }
    
	
	// Select skins change.
    $("#skins").change(function(){
    	fwdmgzSetId = parseInt($("#skins").val());
		
    	$.each(fwdmgzSettingsAr, function(i, el){
			if (fwdmgzSetId == el.id){
				fwdmgzCurOrderId = i;
			}
		});
    	
    	setSettings();
    	
    	if (fwdmgzCurOrderId < DEFAULT_SKINS_NR){
    		$("#update_btn").hide();
            $("#del_btn").hide();
    	}else{
    		$("#update_btn").show();
            $("#del_btn").show();
    	}
    	
    	allFields.removeClass("ui-state-error");
    	$("#tips").text("All form fields are required.");
    	$("#preset_id").html("ID : " + fwdmgzSetId);
    });
    
	
	// Update settings.
    function updateSettings() {
		cur_settings_obj.id = fwdmgzSetId;
		
		// Main settings
		cur_settings_obj.display_type = $("#display_type").val();
		cur_settings_obj.initializeOnlyWhenVisible = $("#initializeOnlyWhenVisible").val();
		cur_settings_obj.name = $("#name").val().replace(/"/g, "'");
		cur_settings_obj.skin_path = $("#skin_path").val().replace(/"/g, "'");
		cur_settings_obj.add_keyboard_support = $("#add_keyboard_support").val();
		cur_settings_obj.use_as_modal = $("#use_as_modal").val();
		cur_settings_obj.add_double_click_support = $("#add_double_click_support").val();
		cur_settings_obj.disable_mouse_wheel = $("#disable_mouse_wheel").val();
		cur_settings_obj.add_keyboard_support = $("#add_keyboard_support").val();
		cur_settings_obj.show_close_button = $("#show_close_button").val();
		cur_settings_obj.show_share_button = $("#show_share_button").val();
		cur_settings_obj.show_zoom_button = $("#show_zoom_button").val();
		cur_settings_obj.show_slide_show_button = $("#show_slide_show_button").val();
		cur_settings_obj.show_slide_show_animation = $("#show_slide_show_animation").val();
		cur_settings_obj.slide_show_delay = $("#slide_show_delay").val();
		cur_settings_obj.hideMarkersByDefault = $("#hideMarkersByDefault").val();
		cur_settings_obj.marker_tool_tip_offset_y = $("#marker_tool_tip_offset_y").val();
		cur_settings_obj.marker_width = $("#marker_width").val();
		cur_settings_obj.marker_height = $("#marker_height").val();
		cur_settings_obj.slide_show_delay_on_mobile = $("#slide_show_delay_on_mobile").val();
		cur_settings_obj.preloaderText = $("#preloaderText").val().replace(/"/g, "'");
		cur_settings_obj.preloaderPosition = $("#preloaderPosition").val();
		cur_settings_obj.preloaderOffsetX = $("#preloaderOffsetX").val();
		cur_settings_obj.preloaderOffsetY = $("#preloaderOffsetY").val();
		cur_settings_obj.showPreloaderProgressBar = $("#showPreloaderProgressBar").val();
		cur_settings_obj.preloaderWidth = $("#preloaderWidth").val().replace(/"/g, "'");
		cur_settings_obj.preloaderBackgroundSize = $("#preloaderBackgroundSize").val();
		cur_settings_obj.preloaderWindowBackgroundOpacity = $("#preloaderWindowBackgroundOpacity").val();
		cur_settings_obj.zoom_factor = $("#zoom_factor").val();
		cur_settings_obj.use_entire_screen = $("#use_entire_screen").val();
		cur_settings_obj.useVectorIcons = $("#useVectorIcons").val();
		cur_settings_obj.pan_speed = $("#pan_speed").val();
		cur_settings_obj.start_zoom_factor = $("#start_zoom_factor").val().replace(/"/g, "'");
		cur_settings_obj.auto_scale = $("#auto_scale").val();
		cur_settings_obj.registrationPoint = $("#registrationPoint").val();
		cur_settings_obj.doubleClickZoomFactor = $("#doubleClickZoomFactor").val();
		cur_settings_obj.viewer_width = $("#viewer_width").val();
		cur_settings_obj.viewer_height = $("#viewer_height").val();
		cur_settings_obj.imageOffsetX = $("#imageOffsetX").val();
		cur_settings_obj.imageOffsetY = $("#imageOffsetY").val();
		cur_settings_obj.pan_speed = $("#pan_speed").val();
		cur_settings_obj.zoomSpeed = $("#zoomSpeed").val();
		cur_settings_obj.space_between_buttons = $("#space_between_buttons").val();
		cur_settings_obj.buttons_offset_in = $("#buttons_offset_in").val();
		cur_settings_obj.buttons_offset_out = $("#buttons_offset_out").val();
		cur_settings_obj.item_border_size = $("#item_border_size").val();
		cur_settings_obj.item_border_radius = $("#item_border_radius").val();
		cur_settings_obj.background_opacity = $("#background_opacity").val();
		cur_settings_obj.preloaderBackgroundColor = $("#preloaderBackgroundColor").spectrum("get") ? $("#preloaderBackgroundColor").spectrum("get").toHexString() : "transparent";
		cur_settings_obj.preloaderFontColor = $("#preloaderFontColor").spectrum("get") ? $("#preloaderFontColor").spectrum("get").toHexString() : "transparent";
		cur_settings_obj.background_color = $("#background_color").spectrum("get") ? $("#background_color").spectrum("get").toRgbString() : "transparent";
		cur_settings_obj.backgroundColorOnZoom = $("#backgroundColorOnZoom").spectrum("get") ? $("#backgroundColorOnZoom").spectrum("get").toRgbString() : "transparent";
		cur_settings_obj.fullscreenBackgroundColor = $("#fullscreenBackgroundColor").spectrum("get") ? $("#fullscreenBackgroundColor").spectrum("get").toHexString() : "transparent";

		// Thumbnail settings.
		cur_settings_obj.controllerVerticalPosition = $("#controllerVerticalPosition").val();
		cur_settings_obj.showControllerBackground = $("#showControllerBackground").val();
		cur_settings_obj.controllerHorizontalPosition = $("#controllerHorizontalPosition").val();
		cur_settings_obj.preloaderFontColor = $("#preloaderFontColor").val();
		cur_settings_obj.inverse_pan_direction = $("#inverse_pan_direction").val();
		cur_settings_obj.add_keyboard_support = $("#add_keyboard_support").val();
		cur_settings_obj.slide_show_auto_play = $("#slide_show_auto_play").val();
		cur_settings_obj.controller_position_small_icon = $("#controller_position_small_icon").val();
		cur_settings_obj.thumbnails_hover_effect = $("#thumbnails_hover_effect").val();
		cur_settings_obj.buttons_tool_tips = $("#buttons_tool_tips").val().replace(/"/g, "'");
		cur_settings_obj.startSpaceBetweenButtons = $("#startSpaceBetweenButtons").val();
		cur_settings_obj.space_between_buttons = $("#space_between_buttons").val();
		cur_settings_obj.start_space_for_scroll_bar_buttons = $("#start_space_for_scroll_bar_buttons").val();
		cur_settings_obj.start_space_for_scroll_bar = $("#start_space_for_scroll_bar").val();
		cur_settings_obj.hide_controller_delay = $("#hide_controller_delay").val();
		cur_settings_obj.buttons = $("#buttons").val().replace(/"/g, "'");
		cur_settings_obj.controller_max_width = $("#controller_max_width").val();
		cur_settings_obj.controller_background_opacity = $("#controller_background_opacity").val();
		cur_settings_obj.controllerOffsetWidth = $("#controllerOffsetWidth").val();
		cur_settings_obj.controller_offset_y = $("#controller_offset_y").val();
		cur_settings_obj.scroll_bar_offset_x = $("#scroll_bar_offset_x").val();
		cur_settings_obj.scrollBarHandlerOffsetX = $("#scrollBarHandlerOffsetX").val();
		cur_settings_obj.scroll_bar_handler_tool_tip_offset_y = $("#scroll_bar_handler_tool_tip_offset_y").val();
		cur_settings_obj.zoom_in_and_out_tool_tip_offset_y = $("#zoom_in_and_out_tool_tip_offset_y").val();
		cur_settings_obj.buttons_tool_tip_offset_y = $("#buttons_tool_tip_offset_y").val();
		cur_settings_obj.link = $("#link").val();
		cur_settings_obj.info_window_background_opacity = $("#info_window_background_opacity").val();
		cur_settings_obj.infoWindowWidth = $("#infoWindowWidth").val();
		cur_settings_obj.button_tool_tip_font_color = $("#button_tool_tip_font_color").spectrum("get") ? $("#button_tool_tip_font_color").spectrum("get").toHexString() : "transparent";
		cur_settings_obj.buttonToolTipBackgroundColor = $("#buttonToolTipBackgroundColor").spectrum("get") ? $("#buttonToolTipBackgroundColor").spectrum("get").toHexString() : "transparent";
		cur_settings_obj.navigator_border_color = $("#navigator_border_color").spectrum("get") ? $("#navigator_border_color").spectrum("get").toHexString() : "transparent";
		cur_settings_obj.info_window_background_color = $("#info_window_background_color").spectrum("get") ? $("#info_window_background_color").spectrum("get").toHexString() : "transparent";
		
		// Description window settings.
		cur_settings_obj.show_navigator = $("#show_navigator").val();
		cur_settings_obj.navigator_position = $("#navigator_position").val();
		cur_settings_obj.navigatorWidth = $("#navigatorWidth").val();
		cur_settings_obj.navigator_offset_x = $("#navigator_offset_x").val();
		cur_settings_obj.navigator_offset_y = $("#navigator_offset_y").val();
		cur_settings_obj.description_window_background_opacity = $("#description_window_background_opacity").val();
		cur_settings_obj.description_window_position = $("#description_window_position").val();
		cur_settings_obj.navigator_handler_color =  $("#navigator_handler_color").spectrum("get") ? $("#navigator_handler_color").spectrum("get").toHexString() : "transparent";
		cur_settings_obj.navigatorBackgroundColor =  $("#navigatorBackgroundColor").spectrum("get") ? $("#navigatorBackgroundColor").spectrum("get").toHexString() : "transparent";
		
		// Video and audio settings.
		cur_settings_obj.showScriptDeveloper = $("#showScriptDeveloper").val();
		cur_settings_obj.context_menu_labels = $("#context_menu_labels").val().replace(/"/g, "'");
		cur_settings_obj.light_box_width = $("#light_box_width").val();
		cur_settings_obj.light_box_height = $("#light_box_height").val();
		cur_settings_obj.light_box_background_opacity = $("#light_box_background_opacity").val();
		cur_settings_obj.video_auto_play = $("#video_auto_play").val();
		cur_settings_obj.video_loop = $("#video_loop").val();
		cur_settings_obj.audio_auto_play = $("#audio_auto_play").val();
		cur_settings_obj.audio_loop = $("#audio_loop").val();
		cur_settings_obj.info_window_scroll_bar_color = $("#info_window_scroll_bar_color").spectrum("get") ? $("#info_window_scroll_bar_color").spectrum("get").toHexString() : "transparent";
		cur_settings_obj.contextMenuBorderColor = $("#contextMenuBorderColor").spectrum("get") ? $("#contextMenuBorderColor").spectrum("get").toRgbString() : "transparent";
		cur_settings_obj.contextMenuSpacerColor = $("#contextMenuSpacerColor").spectrum("get") ? $("#contextMenuSpacerColor").spectrum("get").toHexString() : "transparent";
		cur_settings_obj.contextMenuItemTextNormalColor = $("#contextMenuItemTextNormalColor").spectrum("get") ? $("#contextMenuItemTextNormalColor").spectrum("get").toHexString() : "transparent";
		cur_settings_obj.contextMenuItemTextSelectedColor = $("#contextMenuItemTextSelectedColor").spectrum("get") ? $("#contextMenuItemTextSelectedColor").spectrum("get").toHexString() : "transparent";
		cur_settings_obj.contextMenuItemBackgroundNormalColor = $("#contextMenuItemBackgroundNormalColor").spectrum("get") ? $("#contextMenuItemBackgroundNormalColor").spectrum("get").toHexString() : "transparent";
		cur_settings_obj.contextMenuItemBackgroundSelectedColor = $("#contextMenuItemBackgroundSelectedColor").spectrum("get") ? $("#contextMenuItemBackgroundSelectedColor").spectrum("get").toHexString() : "transparent";
		cur_settings_obj.contextMenuItemDisabledColor = $("#contextMenuItemDisabledColor").spectrum("get") ? $("#contextMenuItemDisabledColor").spectrum("get").toHexString() : "transparent";
		cur_settings_obj.light_box_background_color = $("#light_box_background_color").spectrum("get") ? $("#light_box_background_color").spectrum("get").toHexString() : "transparent";
		cur_settings_obj.preloaderProgressBarBackgroundColor = $("#preloaderProgressBarBackgroundColor").spectrum("get") ? $("#preloaderProgressBarBackgroundColor").spectrum("get").toHexString() : "transparent";
		cur_settings_obj.preloaderProgressBarFillColor = $("#preloaderProgressBarFillColor").spectrum("get") ? $("#preloaderProgressBarFillColor").spectrum("get").toHexString() : "transparent";		
		cur_settings_obj.video_controller_hide_delay = fwdmgzSettingsAr[0].video_controller_hide_delay;
		cur_settings_obj.video_controller_height = fwdmgzSettingsAr[0].video_controller_height;
		cur_settings_obj.audio_controller_height = fwdmgzSettingsAr[0].audio_controller_height;
		cur_settings_obj.startSpaceBetweenButtons = fwdmgzSettingsAr[0].startSpaceBetweenButtons;
		cur_settings_obj.vdSpace_between_buttons = fwdmgzSettingsAr[0].vdSpace_between_buttons;
		cur_settings_obj.main_scrubber_offest_top = fwdmgzSettingsAr[0].main_scrubber_offest_top;
		cur_settings_obj.scrubbers_offset_width = fwdmgzSettingsAr[0].scrubbers_offset_width;
		cur_settings_obj.audio_scrubbers_offest_total_width = fwdmgzSettingsAr[0].audio_scrubbers_offest_total_width;
		cur_settings_obj.time_offset_left_width = fwdmgzSettingsAr[0].time_offset_left_width;
		cur_settings_obj.time_offset_right_width = fwdmgzSettingsAr[0].time_offset_right_width;
		cur_settings_obj.volume_scrubber_width = fwdmgzSettingsAr[0].volume_scrubber_width;
		cur_settings_obj.volume_scrubber_offset_right_width = fwdmgzSettingsAr[0].volume_scrubber_offset_right_width;
    }
    
	// Validation functions.
	var allFields = $([]).add($("#name")).add($("#preloaderText")).add($("#preloaderText")).add($("#zoom_factor")).add($("#imageOffsetY")).add($("#pan_speed")).add($("#pan_speed")).add($("#space_between_buttons")).add($("#buttons_offset_in")).add($("#buttons_offset_out")).add($("#item_border_size")).add($("#item_border_radius")).add($("#background_opacity")).add($("#buttons")).add($("#buttons_tool_tips")).add($("#startSpaceBetweenButtons")).add($("#space_between_buttons")).add($("#start_space_for_scroll_bar_buttons")).add($("#hide_controller_delay")).add($("#description_window_background_opacity")).add($("#start_zoom_factor")).add($("#zoomSpeed")).add($("#slide_show_delay")).add($("#start_space_for_scroll_bar")).add($("#controller_max_width")).add($('#controller_background_opacity')).add($('#scrollBarHandlerOffsetX')).add($("#controller_offset_y")).add($("#scroll_bar_offset_x")).add($('#startSpaceBetweenButtons')).add($("#scroll_bar_handler_tool_tip_offset_y")).add($("#buttons_tool_tip_offset_y")).add($("#zoom_in_and_out_tool_tip_offset_y")).add($('#navigatorWidth')).add($("#navigator_offset_x")).add($("#navigator_offset_y")).add($("#info_window_background_opacity")).add($("#infoWindowWidth")).add($("#context_menu_labels")).add($("#light_box_width")).add($("#light_box_height")).add($("#light_box_background_opacity")).add($('#doubleClickZoomFactor')).add($("#viewer_width")).add($("#viewer_height")).add($("#imageOffsetX")).add($("#imageOffsetY")).add($("#marker_tool_tip_offset_y")).add($("#marker_width")).add($("#marker_height")).add($("#preloaderOffsetX")).add($("#preloaderOffsetY")).add($("#preloaderWidth")).add($("#preloaderWindowBackgroundOpacity"))

	
	var fValid = false;
	function validateFields(){
		fValid = true;
     	
      	allFields.removeClass("ui-state-error");

      	// Main settings.
      	fValid = fValid && checkLength($("#name"), "name", 1, 64);
		fValid = fValid && checkLength($("#start_zoom_factor"), "zoomer image offset Y", 1, 8);
		fValid = fValid && checkLength($("#imageOffsetY"), "imageOffsetY", 1, 64);
		fValid = fValid && checkIfFloatAndLength2($("#zoom_factor"), "zoom factor", 1, 3);
		fValid = fValid && checkIfFloatAndLength2($("#zoomSpeed"), "zoom speed", 1, 3);
		fValid = fValid && checkIfIntegerAndLength($("#pan_speed"), "pan speed", 1, 3);
		fValid = fValid && checkIfFloatAndLength2($("#doubleClickZoomFactor"), "double click zoom factor", 1, 3);
		fValid = fValid && checkIfIntegerAndLength($("#viewer_width"), "zoomer max width", 1, 5);
		fValid = fValid && checkIfIntegerAndLength($("#viewer_height"), "zoomer max height", 1, 5);
		fValid = fValid && checkIfIntegerAndLength($("#imageOffsetX"), "image offset X", 1, 5);
		fValid = fValid && checkIfIntegerAndLength($("#imageOffsetX"), "image offset Y", 1, 5);
		fValid = fValid && checkIfIntegerAndLength($("#marker_tool_tip_offset_y"), "markers tooltip offset y", 1, 4);
		fValid = fValid && checkIfIntegerAndLength($("#marker_width"), "markers icon width", 1, 4);
		fValid = fValid && checkIfIntegerAndLength($("#marker_height"), "markers icon height", 1, 4);
      	if (!fValid){
      		$("#tabs").tabs("option", "active", 0);
      		window.scrollTo(0,0);	
      		return false;
      	}
	
		fValid = fValid && checkIfIntegerAndLength($("#startSpaceBetweenButtons"), "start space between buttons", 1, 4);
		fValid = fValid && checkIfIntegerAndLength($("#space_between_buttons"), "space between buttons", 1, 4);
		fValid = fValid && checkIfIntegerAndLength($("#start_space_for_scroll_bar_buttons"), "start space between scrollbar buttons", 1, 4);
		fValid = fValid && checkIfIntegerAndLength($("#start_space_for_scroll_bar"), "start space for scrollbar", 1, 8);
		fValid = fValid && checkIfIntegerAndLength($("#hide_controller_delay"), "controller hide delay", 1, 6);
		fValid = fValid && checkIfIntegerAndLength($("#controller_max_width"), "controller max width", 1, 4);
		fValid = fValid && checkIfFloatAndLength($("#controller_background_opacity"), "controller background opacity", 1, 4);	
		fValid = fValid && checkIfIntegerAndLength($("#controllerOffsetWidth"), "controller offset width", 1, 4);
		fValid = fValid && checkIfIntegerAndLength($("#controller_offset_y"), "controller offset y", 1, 4);
		fValid = fValid && checkIfIntegerAndLength($("#scroll_bar_offset_x"), "scrollbar offset x", 1, 4);
		fValid = fValid && checkIfIntegerAndLength($("#scrollBarHandlerOffsetX"), "scrollbar handler offset x", 1, 4);
		fValid = fValid && checkIfIntegerAndLength($("#scroll_bar_handler_tool_tip_offset_y"), "scrollbar handler tooltip offset y", 1, 4);
		fValid = fValid && checkIfIntegerAndLength($("#zoom_in_and_out_tool_tip_offset_y"), "zoom in and out tooltip offset y", 1, 4);
		fValid = fValid && checkIfIntegerAndLength($("#buttons_tool_tip_offset_y"), "buttons tooltip offset y", 1, 4);
		
      	if (!fValid){
      		$("#tabs").tabs("option", "active", 1);
      		window.scrollTo(0,0);	
      		return false;
      	}
		
		// Navigator.
		fValid = fValid && checkIfIntegerAndLength($("#navigatorWidth"), "navigator width", 1, 4);
		fValid = fValid && checkIfIntegerAndLength($("#navigator_offset_x"), "navigator offset x", 1, 4);
		fValid = fValid && checkIfIntegerAndLength($("#navigator_offset_y"), "navigator offset y", 1, 4);
		
      	if (!fValid){
      		$("#tabs").tabs("option", "active", 2);
      		window.scrollTo(0,0);	
      		return false;
      	}
		
		// Info window.
		fValid = fValid && checkIfFloatAndLength($("#info_window_background_opacity"), "info window background opacity", 1, 4);
		fValid = fValid && checkIfIntegerAndLength($("#infoWindowWidth"), "info window width", 1, 4);
		
      	if (!fValid){
      		$("#tabs").tabs("option", "active", 3);
      		window.scrollTo(0,0);	
      		return false;
      	}
		
		// Lightbox.
		fValid = fValid && checkIfIntegerAndLength($("#light_box_width"), "lightbox width", 1, 8);
		fValid = fValid && checkIfIntegerAndLength($("#light_box_height"), "lightbox height", 1, 8);
		fValid = fValid && checkIfFloatAndLength($("#light_box_background_opacity"), "lightbox background opacity", 1, 8);
		if (!fValid){
      		$("#tabs").tabs("option", "active", 5);
      		window.scrollTo(0,0);	
      		return false;
      	}

      	// Prelaoder.
      	fValid = fValid && checkLength($("#preloaderText"), "preloader text", 1, 200);
      	fValid = fValid && checkIfIntegerAndLength($("#preloaderOffsetX"), "preloader offset x", 1, 3);
		fValid = fValid && checkIfIntegerAndLength($("#preloaderOffsetY"), "preloader offset y", 1, 3);
		fValid = fValid && checkLength($("#preloaderWidth"), "preloader width", 1, 7);
		fValid = fValid && checkIfFloatAndLength2($("#preloaderWindowBackgroundOpacity"), "preloader window background opacity", 1, 8);

		if (!fValid){
      		$("#tabs").tabs("option", "active", 6);
      		window.scrollTo(0,0);	
      		return false;
      	}
	}
    
	
	// Add/edit/delete buttons..
    $("#add_btn").click(function(e){
		if($("#name").val() == fwdmgzSettingsAr[fwdmgzCurOrderId]["name"]){
			updateTips("Please make sure that the preset name is unique");
			$("#name").addClass("ui-state-error");
			$("#tabs").tabs("option", "active", 0);
			window.scrollTo(0,0);
			return false;
		};
		
    	validateFields();
		
      	if (fValid) {
      		cur_settings_obj = {};
        	
        	fwdmgzSetId = $("#skins option").length;
        	fwdmgzCurOrderId = $("#skins option").length;
        	
      		var idsAr = [];
      		
      		if (fwdmgzSetId > DEFAULT_SKINS_NR){
      			$.each(fwdmgzSettingsAr, function(i, el){
    				idsAr.push(el.id);
    			});
          		
          		for (var i=DEFAULT_SKINS_NR; i<fwdmgzSettingsAr.length; i++){
          			if ($.inArray(i, idsAr) == -1){
          				fwdmgzSetId = i;
          				break;
          			}
          		}
      		}
        	
	    	updateSettings();
	    	
	    	fwdmgzSettingsAr.push(cur_settings_obj);
	    	
	    	var data_obj = {
	    		action: "add",
	    		set_id: fwdmgzSetId,
	    		set_order_id: fwdmgzCurOrderId,
	    		tab_init_id: $("#tabs").tabs("option", "active"),
	    		settings_ar: fwdmgzSettingsAr
	    	};
	  
	    	$("#settings_data").val(JSON.stringify(data_obj));
        }else{
      		return false;
      	}
    });
    

    // Update presets.
    $("#update_btn").click(function(){
    	validateFields();
      	if (fValid){
      		cur_settings_obj = {};
      		
	    	updateSettings();
	    	
	    	fwdmgzSettingsAr[fwdmgzCurOrderId] = cur_settings_obj;
	    	
	    	var data_obj ={
	    		action: "save",
	    		set_id: fwdmgzSetId,
	    		set_order_id: fwdmgzCurOrderId,
	    		tab_init_id: $("#tabs").tabs("option", "active"),
	    		settings_ar: fwdmgzSettingsAr
	    	};
	    	
	    	$("#settings_data").val(JSON.stringify(data_obj));
        }else{
      		return false;
      	}
    });
    
    // Delete presets.
    $("#del_btn").click(function(){
    	fwdmgzSettingsAr.splice(fwdmgzCurOrderId, 1);
    	
    	var data_obj ={
    		action: "del",
    		settings_ar: fwdmgzSettingsAr
    	};
 
    	$("#settings_data").val(JSON.stringify(data_obj));
    });
	

	// Utils.
	function checkLength(el, prop, min, max){
      	if ((el.val().length > max) || (el.val().length < min)){
        	el.addClass("ui-state-error");
        	updateTips("Length of " + prop + " must be between " + min + " and " + max + ".");
        	
        	return false;
      	}else{
        	return true;
      	}
	}
    
    function checkIfIntegerAndLength(el, prop, min, max){
    	var int_reg_exp = /-?[0-9]+/;
    	var str = el.val();
    	var res = str.match(int_reg_exp);
		
    	if (res && (res[0] == str)){
    		if ((el.val().length > max) || (el.val().length < min)){
            	el.addClass("ui-state-error");
            	updateTips("Length of " + prop + " must be between " + min + " and " + max + ".");	
            	return false;
          	}else{
            	return true;
          	}
        }else{
        	el.addClass("ui-state-error");
        	updateTips("The " + prop + " field value must be an integer.");
        	return false;
        }
	}
    
    function checkIfFloatAndLength(el, prop, min, max){
    	var float_reg_exp = /1\.0|0?\.[0-9]+|[01]/;
    	var str = el.val();
    	var res = str.match(float_reg_exp);
    	
    	if (res && (res[0] == str)) {
    		if ((el.val().length > max) || (el.val().length < min)){
            	el.addClass("ui-state-error");
            	updateTips("Length of " + prop + " must be between " + min + " and " + max + ".");
            	
            	return false;
          	}else{
            	return true;
          	}
        }else{
        	el.addClass("ui-state-error");
        	updateTips("The " + prop + " field value must be a float number.");	
        	return false;
        }
	}
	
	function checkIfFloatAndLength2(el, prop, min, max){
    	var float_reg_exp = /[0-9]*\.?[0-9]+/;
    	var str = el.val();
    	var res = str.match(float_reg_exp);
    	
    	if (res && (res[0] == str)){
    		if ((el.val().length > max) || (el.val().length < min)){
            	el.addClass("ui-state-error");
            	updateTips("Length of " + prop + " must be between " + min + " and " + max + ".");
            	
            	return false;
          	}else{
            	return true;
          	}
        }else{
        	el.addClass("ui-state-error");
        	updateTips("The " + prop + " field value must be a float number.");
        	
        	return false;
        }
	}

	function updateTips(txt){
		$("#tips").text(txt).addClass("ui-state-highlight");
	    setTimeout(function(){
	    	$("#tips").removeClass("ui-state-highlight", 1500);
	    }, 500);
	    
	    $("#tips").addClass("fwd-error");
	}

	function escapeHtml(str) {
        var map = {
            "&": "&amp;",
            "<": "&lt;",
            ">": "&gt;",
            "\"": "&quot;",
            "'": "&#039;"
        };
        str = str.replace(/'/g, "\"");
        return str.replace(/[&<>"']/g, function(m) { return map[m]; });
    }

    function unescapeHtml(str) {
        var map = {
            "&amp;": "&",
            "&lt;": "<",
            "&gt;": ">",
            "&quot;": "\"",
            "&#039;": "'"
        };
        return str.replace(/(&amp;|&lt;|&gt;|&quot;|&#039;)/g, function(m) { return map[m]; });
    }

    function removeFirstAndLastChar(str){
        str = str.substring(1);
        str = str.slice(0, -1);
        return str;
    }
	
});